#!/bin/sh
# number of taxa
N="64 128 256 512"
# sizes
K="1024 2048 4096 8192 16384 32768 131072 262144"

echo "============"
echo "TESTS ON CPU"
echo "============"

method=2
if test $# -eq 1 ; then
	method=$1
fi

# extract cpu name
cpu_name=`cat /proc/cpuinfo | grep "^model name" | head -1 | cut -d':' -f2 | sed -e "s/([RTM]\+)//g" |  sed -e "s/^[ ]\+//" | tr ' ' '-'`

# get name of method given as a parameter, or if not
# use method 2
method_name=`bin/main.exe  --get-method-name=${method} 2>&1`
echo ${method_name} 
err=`echo ${method_name} | grep "error"`
if test ! -z "$err" ; then
	echo "error: method ${method} not recognized"
	exit 1;
fi

method_name=`echo ${method_name} | cut -d'=' -f2`

# use static tree implementation and cpu test
params="--tree-implementation=2 --test=2 --method=${method}"
results="results/cpu_${cpu_name}_${method_name}.txt"
rm -rf $results

echo "generate results in $results"

stdout="tmp/stdout.txt"
stderr="tmp/stderr.txt"
for n in $N ; do
	for k in $K ; do 
		echo "./bin/main.exe --nbr-taxa=$n --taxa-length=$k $params >$stdout 2>$stderr "
		time ./bin/main.exe --nbr-taxa=$n --taxa-length=$k $params >$stdout 2>$stderr 
		t=`cat $stdout | grep "cpu elapsed=" | cut -d'=' -f2`
		echo "$n; $k; $t;"		
		echo "$n; $k; $t;"	>> $results
	done
done
