/*
 * static_tree.h
 *
 *  Created on: Jan 31, 2014
 *      Author: richer
 */

#ifndef STATIC_TREE_H_
#define STATIC_TREE_H_

#include "tree.h"

class StaticTree : public Tree {
public:
	typedef struct {
		int l,r,p,n;
	} Node;

	Node *nodes;

	StaticTree();
	StaticTree(StaticTree& t);
	~StaticTree();

	Tree *generate_random();
	Tree *generate_comb();
	Tree *generate_balanced();

	int get_depth();
	int count_nodes();

	void to_newick(ostream& out);

private:
	int _count_nodes(int k);
	int _get_depth(int k);
	void _to_newick(int k, ostream& out);
};

#endif /* STATIC_TREE_H_ */
