/*
 * static_tree.cpp
 *
 *  Created on: Jan 31, 2014
 *      Author: richer
 */

#include "static_tree.h"
#include "parameters.h"
#include <string.h>

StaticTree::StaticTree() :  Tree() {
	// reserve enough space to store data on GPU
	nodes = new Node [ Parameters::MAX_STATIC_TREE_NODES ];
	for (int i=0; i<Parameters::get_instance().nbr_taxa; ++i) {
		nodes[i].l = -1;
		nodes[i].r = -1;
		nodes[i].n = i;
	}
}

StaticTree::StaticTree(StaticTree& t) : Tree() {
	// reserve enough space to store data on GPU
	nodes = new Node [ Parameters::MAX_STATIC_TREE_NODES ];
	memcpy(nodes, t.nodes, (2*Parameters::get_instance().nbr_taxa-1) * sizeof(Node));
}

StaticTree::~StaticTree() {
	delete [] nodes;
}

Tree *StaticTree::generate_random() {
	vector<int> nodes;

	StaticTree *t = new StaticTree;

	for (int i=0; i<Parameters::get_instance().nbr_taxa; ++i) {
		nodes.push_back(i);
	}

	int k = Parameters::get_instance().nbr_taxa;
	while (nodes.size() > 1) {
		int i = rand() % nodes.size();
		int v_i = nodes[i];
		nodes.erase(nodes.begin() + i);
		int j = rand() % nodes.size();
		int v_j = nodes[j];
		nodes.erase(nodes.begin() + j);
		t->nodes[k].l = v_i;
		t->nodes[k].r = v_j;
		t->nodes[v_i].p = k;
		t->nodes[v_j].p = k;
		nodes.push_back(k);
		++k;
	}
	t->nodes[k-1].p = -1;
	return t;
}

Tree *StaticTree::generate_comb() {
	vector<int> nodes;

	StaticTree *t = new StaticTree;

	for (int i=0; i<Parameters::get_instance().nbr_taxa; ++i) {
		nodes.push_back(i);
	}

	int k = Parameters::get_instance().nbr_taxa;
	while (nodes.size() > 1) {
		int i = 0;
		int v_i = nodes[i];
		nodes.erase(nodes.begin() + i);
		int j = 0;
		int v_j = nodes[j];
		nodes.erase(nodes.begin() + j);
		t->nodes[k].l = v_i;
		t->nodes[k].r = v_j;
		t->nodes[v_i].p = k;
		t->nodes[v_j].p = k;
		nodes.insert(nodes.begin(), k);
		++k;
	}
	t->nodes[k-1].p = -1;
	//cerr << endl;
	//cerr << "out of here";
	return t;
}

Tree *StaticTree::generate_balanced() {
	vector<int> nodes, tmp;

	StaticTree *t = new StaticTree;

	for (int i=0; i<Parameters::get_instance().nbr_taxa; ++i) {
		nodes.push_back(i);
	}

	int k = Parameters::get_instance().nbr_taxa;
	while (nodes.size() > 1) {
		tmp.clear();
		while (nodes.size() != 0) {
			int i = 0;
			int v_i = nodes[i];
			nodes.erase(nodes.begin() + i);
			int j = 0;
			int v_j = nodes[j];
			nodes.erase(nodes.begin() + j);
			t->nodes[k].l = v_i;
			t->nodes[k].r = v_j;
			t->nodes[v_i].p = k;
			t->nodes[v_j].p = k;
			tmp.push_back(k);
			//cerr << i << "," << j << ",";
			//cerr << "k=" << k << ", i=" << v_i << ", j=" << v_j << ", size=" << nodes.size() << endl;
			++k;
		}
		nodes.clear();
		//copy(tmp.begin(), tmp.end(), ostream_iterator<int>(cerr," ")); cerr << endl;
		copy(tmp.begin(), tmp.end(), back_inserter(nodes));
	}
	//cerr << "k = " << k << endl;
	t->nodes[k-1].p = -1;
	return t;
}

int StaticTree::get_depth() {
	return _get_depth(2*Parameters::get_instance().nbr_taxa-2);
}

int StaticTree::_count_nodes(int k) {
	if ((nodes[k].l == -1) && (nodes[k].r == -1)) {
		return 1;
	} else {
		return 1 + _count_nodes(nodes[k].l) + _count_nodes(nodes[k].r);
	}
}

int StaticTree::_get_depth(int k) {
	if ((nodes[k].l == -1) && (nodes[k].r == -1)) {
		return 1;
	} else {
		return 1 + max(_get_depth(nodes[k].l),_get_depth(nodes[k].r));
	}
}

int StaticTree::count_nodes() {
	return _count_nodes(2*Parameters::get_instance().nbr_taxa-2);
}

void StaticTree::_to_newick(int k, ostream& out) {
	if ((nodes[k].l == -1) && (nodes[k].r == -1)) {
		out << nodes[k].n;
	} else {
		out << "(";
		_to_newick(nodes[k].l, out);
		out << ",";
		_to_newick(nodes[k].r, out);
		out << ")";
	}
}

void StaticTree::to_newick(ostream& out) {
	_to_newick(2*Parameters::get_instance().nbr_taxa-2, out);
}
