/*
 * static_sequences.h
 *
 *  Created on: Jan 30, 2014
 *      Author: richer
 */

#ifndef STATIC_SEQUENCES_H_
#define STATIC_SEQUENCES_H_

#include <iostream>
#include <vector>
#include "sequence.h"
#include "parsimony.h"
using namespace std;

class StaticSequences {
public:
	StaticSequences();
	~StaticSequences();

	void setup(vector<Sequence *>& v);

	ResidueType *get_sequence(int n);

	ResidueType *tab;
	uint32_t full_size;
	uint32_t taxa_length_aligned;

	void display(ostream& out);

	friend ostream& operator<<(ostream& out, StaticSequences& s) {
		s.display(out);
		return out;
	}
};

#endif /* STATIC_SEQUENCES_H_ */
