/*
 * static_sequences.cpp
 *
 *  Created on: Jan 30, 2014
 *      Author: richer
 */

#include <xmmintrin.h>
#include <string.h>
#include "static_sequences.h"
#include "parameters.h"

StaticSequences::StaticSequences() {
	tab = NULL;
	full_size = taxa_length_aligned = 0;
}

void StaticSequences::setup(vector<Sequence *>& v) {
	uint32_t tl = Parameters::get_instance().taxa_length;
	taxa_length_aligned = ((tl + CPU_MEMORY_ALIGNMENT - 1) / CPU_MEMORY_ALIGNMENT)
					* CPU_MEMORY_ALIGNMENT;
	full_size = (Parameters::get_instance().nbr_taxa * 2 - 1)
					* taxa_length_aligned * sizeof(ResidueType);

	tab = static_cast<ResidueType *>(_mm_malloc(full_size, CPU_MEMORY_ALIGNMENT));
	memset(tab, 0, full_size);

	vector<Sequence *>::iterator iter;
	uint32_t offset = 0;
	for (iter = v.begin(); iter!= v.end(); ++iter) {
		memcpy((void *) &tab[offset], (void *) (*iter)->get_residues(), tl * sizeof(ResidueType));
		offset += taxa_length_aligned;
	}
}

StaticSequences::~StaticSequences() {
	if (tab != NULL) _mm_free(tab);
}

ResidueType *StaticSequences::get_sequence(int n) {
	return &tab[n * taxa_length_aligned];
}

void StaticSequences::display(ostream& out) {
	out << endl;
	out << "=== static sequences ===" << endl;
	out << "taxa_length_aligned=" << taxa_length_aligned << endl;
	out << "cpu memory alignment=" << CPU_MEMORY_ALIGNMENT << endl;
	out << "full_size=" << full_size << " (=" <<  taxa_length_aligned
			<< " * " << (Parameters::get_instance().nbr_taxa * 2 - 1)
			<< " * " << sizeof(ResidueType) << ")" << endl;
}




