/*
 * sequence.h
 *
 *  Created on: Jan 29, 2014
 *      Author: richer
 */

#ifndef SEQUENCE_H_
#define SEQUENCE_H_

#include <iostream>
#include <string>
using namespace std;
#include "parsimony.h"

class Sequence {
public:
	/**
	 * generate sequence from given array
	 * input residues will be copied into a new allocated array
	 * of size Parameters::get_instance().taxa_length;
	 */
	Sequence(ResidueType *_residues);

	/**
	 * generate random sequence of size Parameters::get_instance().taxa_length;
	 */
	Sequence();

	/**
	 * generate sequence of size Parameters::get_instance().taxa_length with
	 * each residue of value v
	 */
	Sequence(int v);

	/**
	 * generate sequence with repeated values
	 */
	Sequence(int *val, int n);

	~Sequence();

	ResidueType *get_residues() { return residues; }

	void display(ostream& out);

	friend ostream& operator<<(ostream& out, Sequence& s) {
		s.display(out);
		return out;
	}
private:
	ResidueType *residues;
};


#endif /* SEQUENCE_H_ */
