/*
 * sequence.cpp
 *
 *  Created on: Jan 29, 2014
 *      Author: richer
 */

#include "sequence.h"
#include <cstring>
#include <cstdlib>
#include "parameters.h"

Sequence::Sequence(ResidueType *_residues) {
	int size = Parameters::get_instance().taxa_length;
	residues = new ResidueType[ size ];
	memcpy(residues, _residues, size * sizeof(ResidueType));
}


Sequence::Sequence() {
	int size = Parameters::get_instance().taxa_length;
	residues = new ResidueType[ size ];
	for (int i=0; i<size; ++i) {
		residues[i] = rand() % 17;
	}
}

Sequence::Sequence(int v) {
	int size = Parameters::get_instance().taxa_length;
	residues = new ResidueType[ size ];
	for (int i=0; i<size; ++i) {
		residues[i] = v;
	}
}

Sequence::Sequence(int *val, int n) {
	int size = Parameters::get_instance().taxa_length;
	residues = new ResidueType[ size ];
	for (int i=0; i<size; ++i) {
		residues[i] = val[i % n];
	}
}

Sequence::~Sequence() {
	delete [] residues;
}

void Sequence::display(ostream& out) {
	for (int i=0;i<16; ++i) {
		cerr << (int) residues[i] << " ";
	}
}
