/*
 * parsimony.h
 *
 *  Created on: Jan 29, 2014
 *      Author: richer
 */

#ifndef PARSIMONY_H_
#define PARSIMONY_H_

#include "cpu_config.h"
#include <stdint.h>
#include <iostream>
using namespace std;
#include "dynamic_tree.h"
#include "static_tree.h"

#ifdef CPU_DATA_SIZE_8_BITS
typedef uint8_t ResidueType;
#endif

#ifdef CPU_DATA_SIZE_32_BITS
typedef uint32_t ResidueType;
#endif

typedef int (*ParsimonyMethodType)(ResidueType *x, ResidueType *y, ResidueType *z, int size);

int parsimony_reference(ResidueType *x, ResidueType *y, ResidueType *z, int size);


class Parsimony {
public:
	static int get_nbr_methods();
	static const char *get_method_name(int n);
	static int execute(int n, ResidueType *x, ResidueType *y, ResidueType *z, int size);

	static int score(DynamicTree& t);
	static int score(StaticTree& t);

protected:
	static int score(DynamicTree::Node *node);
	static int score(int k, StaticTree::Node *node);
};


#endif /* PARSIMONY_H_ */
