/*
 * parameters.h
 *
 *  Created on: Jan 29, 2014
 *      Author: richer
 */

#ifndef PARAMETERS_H_
#define PARAMETERS_H_

#include <iostream>
using namespace std;

class Parameters {
private:
	Parameters();
	static Parameters *params;

public:
	int test;
	int seed;
	int method;
	int nbr_taxa;

	int taxa_length;
	int max_iterations;
	int nbr_trees;
	int tree_implementation ; // 1=dynamic, 2=static
	int tree_topology; // 1=random, 2=comb, 3=balanced
	int taxa_initialization; // 1=random
	int threads_per_block;
	int gpu_selected;

	enum {
		MAX_STATIC_TREE_NODES = 1024 // for GPU to store static tree
	};

	enum { TREE_IMPLEMENTATION_DYNAMIC=1,
		TREE_IMPLEMENTATION_STATIC=2
	};
	enum { TREE_TOPOLOGY_RANDOM = 1,
		TREE_TOPOLOGY_COMB,
		TREE_TOPOLOGY_BALANCED };
	enum {
		TAXA_INITIALIZATION_RANDOM = 1,
		TAXA_INITIALIZATION_CONSTANT = 2
	};
	enum {
		NO_GPU_SELECTED = -1,
		GPU_SELECTED_0 = 0,
		GPU_SELECTED_1 = 1,
		GPU_SELECTED_2 = 2,
		GPU_SELECTED_3 = 3
	};


public:
	static Parameters& get_instance();

	void display(ostream& out);

	friend ostream& operator<<(ostream& out, Parameters& p) {
		p.display(out);
		return out;
	}

};


#endif /* PARAMETERS_H_ */
