/*
 * parameters.cpp
 *
 *  Created on: Jan 29, 2014
 *      Author: richer
 */

#include "parameters.h"

Parameters *Parameters::params = NULL;

const int DEFAULT_TEST = 1;
const int DEFAULT_METHOD = 1;
const int DEFAULT_NBR_TAXA = 64;
const int DEFAULT_TAXA_LENGTH = 1024;
const int DEFAULT_MAX_ITERATIONS = 500;
const int DEFAULT_NBR_TREES = 50;
const int DEFAULT_THREADS_PER_BLOCK = 1024;

Parameters::Parameters() {
	test = DEFAULT_TEST;
	seed = 0;
	method = DEFAULT_METHOD;
	nbr_taxa = DEFAULT_NBR_TAXA;
	taxa_length = DEFAULT_TAXA_LENGTH;
	max_iterations = DEFAULT_MAX_ITERATIONS;
	nbr_trees = DEFAULT_NBR_TREES;
	tree_implementation = TREE_IMPLEMENTATION_DYNAMIC;
	tree_topology = TREE_TOPOLOGY_RANDOM;
	taxa_initialization = TAXA_INITIALIZATION_RANDOM;
	threads_per_block = DEFAULT_THREADS_PER_BLOCK;
	gpu_selected = NO_GPU_SELECTED;
}

Parameters& Parameters::get_instance() {
	if (params == NULL) {
		params = new Parameters();
	}
	return *params;
}

void Parameters::display(ostream& out) {
	out << "=== parameters ===" << endl;
	out << "seed=" << seed << endl;
	out << "test=" << test << endl;
	out << "method=" << method<< endl;
	out << "nbr_taxa=" << nbr_taxa<< endl;
	out << "taxa_length=" << taxa_length<< endl;
	out << "max_iterations=" << max_iterations<< endl;
	out << "nbr_trees=" << nbr_trees<< endl;
	out << "tree_implementation=" << tree_implementation << endl;
	out << "tree_topology=" <<tree_topology<< endl;
	out << "taxa_initialization=" << taxa_initialization << endl;
	out << "threads_per_block=" << threads_per_block << endl;
	out << "gpu_selected=" << gpu_selected << endl;
}

