#include "gpu_chrono.h"

cudaEvent_t startEvent, stopEvent;

GPUChrono::GPUChrono() {
	cudaEventCreate(&startEvent);
	cudaEventCreate(&stopEvent);
}

GPUChrono::~GPUChrono() {
	cudaEventDestroy(startEvent);
	cudaEventDestroy(stopEvent);
}

void GPUChrono::start() {
	cudaEventRecord(startEvent, 0);
}

void GPUChrono::stop() {
	cudaEventRecord(stopEvent, 0);
	cudaEventSynchronize(stopEvent); 
}

double GPUChrono::elapsed() {
	float elapsedTime; // Initialize elapsedTime;
	cudaEventElapsedTime(&elapsedTime, startEvent, stopEvent);
	// divide by 1000 to get time in seconds
	return (elapsedTime / 1000.0);
}

void GPUChrono::display(ostream& out) {
	out << elapsed();
}