/*
 * dynamic_tree.h
 *
 *  Created on: Jan 31, 2014
 *      Author: richer
 */

#ifndef DYNAMIC_TREE_H_
#define DYNAMIC_TREE_H_

#include "tree.h"

class DynamicTree : public Tree {
public:
	class Node {
	public:
		Node *l, *r, *p;
		int n;
		Node() {
			l=r=p=NULL;
			n=-1;
		}
		Node(Node *_l, Node *_r, int _n) {
			l=_l;
			r=_r;
			p = NULL;
			n=_n;
		}
		Node(int _n) {
			l=r=p=NULL;
			n=_n;
		}
		bool is_leaf() {
			return (l==NULL) && (r==NULL);
		}
		Node *clone() {
			Node *dup = new Node();
			if (l!=NULL) {
				dup->l = l->clone();
				dup->l->p = dup;
			}
			if (r!=NULL) {
				dup->r = r->clone();
				dup->r->p = dup;
			}
			dup->n = n;
			return dup;
		}
		void destroy() {

			if (l!=NULL) {
				l->destroy();
				delete l;
			}
			if (r!=NULL) {
				r->destroy();
				delete r;
			}
			//cerr << "delete node " << n << " " << this << " "
			//					<< "l=" << l << ", r=" << r << endl;
		}
		int get_depth() {
			if ((l==NULL) && (r==NULL)) return 1;
			return 1 + max(l->get_depth(), r->get_depth());
		}
		int count_nodes() {
			if ((l==NULL) && (r==NULL)) return 1;
			return 1 + l->count_nodes() + r->count_nodes();
		}
		void to_newick(ostream& out) {
			if (is_leaf()) {
				out << n;
			} else {
				out << "(";
				l->to_newick(out);
				out << ",";
				r->to_newick(out);
				out << ")";
			}
		}
		void get_nodes(vector<Node *>& lst) {
			lst.push_back(this);
			if (l != NULL) l->get_nodes(lst);
			if (r != NULL) r->get_nodes(lst);
		}
	};

	Node *root;

	DynamicTree();
	DynamicTree(Node *_root);
	DynamicTree(DynamicTree& t);
	DynamicTree& operator=(DynamicTree& t);
	~DynamicTree();

	Tree *generate_random();
	Tree *generate_comb();
	Tree *generate_balanced();

	int get_depth();
	int count_nodes();

	void to_newick(ostream& out);

	void get_nodes(vector<Node *>& l);

};


#endif /* DYNAMIC_TREE_H_ */
