/*
 * dynamic_tree.cpp
 *
 *  Created on: Jan 31, 2014
 *      Author: richer
 */

#include "dynamic_tree.h"
#include <stdlib.h>

DynamicTree::DynamicTree() : Tree() {
	root = NULL;
}

DynamicTree::DynamicTree(Node *_root) : Tree() {
	root = _root;
}

DynamicTree::DynamicTree(DynamicTree& t) : Tree() {
	root = t.root->clone();
}

DynamicTree::~DynamicTree() {
	if (root != NULL) {
		root->destroy();
		delete root;
	}
}

DynamicTree& DynamicTree::operator=(DynamicTree& t) {
	if (&t != this) {
		root->destroy();
		root = t.root->clone();
	}
	return *this;
}

Tree *DynamicTree::generate_random() {
	vector<Node *> nodes;

	for (int i=0; i<Parameters::get_instance().nbr_taxa; ++i) {
		nodes.push_back(new Node(i));
	}

	int k = Parameters::get_instance().nbr_taxa;
	while (nodes.size() > 1) {
		int i = rand() % nodes.size();
		Node *v_i = nodes[i];
		nodes.erase(nodes.begin() + i);
		int j = rand() % nodes.size();
		Node *v_j = nodes[j];
		nodes.erase(nodes.begin() + j);
		Node *new_node = new Node(v_i, v_j, k);
		v_i->p = new_node;
		v_j->p = new_node;
		nodes.push_back(new_node);
		++k;
	}
	//cerr << endl;
	//cerr << "out of here";
	return new DynamicTree(nodes[0]);
}

Tree *DynamicTree::generate_comb() {
	vector<Node *> nodes;

	for (int i=0; i<Parameters::get_instance().nbr_taxa; ++i) {
		nodes.push_back(new Node(i));
	}

	int k = Parameters::get_instance().nbr_taxa;
	while (nodes.size() > 1) {
		int i = 0;
		Node *v_i = nodes[i];
		nodes.erase(nodes.begin() + i);
		int j = 0;
		Node *v_j = nodes[j];
		nodes.erase(nodes.begin() + j);
		Node *new_node = new Node(v_i, v_j, k);
		v_i->p = new_node;
		v_j->p = new_node;
		nodes.insert(nodes.begin(), new_node);
		++k;
	}
	//cerr << endl;
	//cerr << "out of here";
	return new DynamicTree(nodes[0]);
}

Tree *DynamicTree::generate_balanced() {
	vector<Node *> nodes;

	for (int i=0; i<Parameters::get_instance().nbr_taxa; ++i) {
		nodes.push_back(new Node(i));
	}

	int k = Parameters::get_instance().nbr_taxa;
	while (nodes.size() > 1) {
		vector<Node *> tmp;
		for (int i = 0; i < static_cast<int>(nodes.size()); i += 2) {
			Node *v_i = nodes[i];
			//nodes.erase(nodes.begin() + i);
			int j = i+1;
			Node *v_j = nodes[j];
			//nodes.erase(nodes.begin() + j);
			Node *new_node = new Node(v_i, v_j, k);
			v_i->p = new_node;
			v_j->p = new_node;
			tmp.push_back(new_node);
			++k;
		}
		nodes.clear();
		copy(tmp.begin(), tmp.end(), back_inserter(nodes));
	}
	//cerr << endl;
	//cerr << "out of here";
	return new DynamicTree(nodes[0]);
}

int DynamicTree::get_depth() {
	return root->get_depth();
}

int DynamicTree::count_nodes() {
	return root->count_nodes();
}

void DynamicTree::to_newick(ostream& out) {
	root->to_newick(out);
}

void DynamicTree::get_nodes(vector<Node *>& l) {
	root->get_nodes(l);
}
