#include "cuda_part.h"

void printDevProp(int i, cudaDeviceProp devProp) {
	cout << "---------------------" << endl;
	cout << "CUDA Device #" << i << endl;
	cout << "---------------------" << endl;

    cout << "Major revision number         =" << devProp.major << endl;
    cout << "Minor revision number         =" << devProp.minor << endl;
    cout << "Name                          =" << devProp.name << endl;
    cout << "Total global memory           =" << devProp.totalGlobalMem << endl;
    cout << "Total shared memory per block =" << devProp.sharedMemPerBlock << endl;
    cout << "Total registers per block     =" << devProp.regsPerBlock << endl;
    cout << "Warp size                     =" << devProp.warpSize << endl;
    cout << "Maximum memory pitch          =" << devProp.memPitch << endl;
    cout << "Maximum threads per block     =" << devProp.maxThreadsPerBlock << endl;
    for (int i = 0; i < 3; ++i)
    cout << "Maximum dimension " << i << " of block =" << devProp.maxThreadsDim[i] << endl;
    for (int i = 0; i < 3; ++i)
    cout << "Maximum dimension " << i << " of grid =" << devProp.maxGridSize[i] << endl;
    cout << "Clock rate                    =" <<  devProp.clockRate << endl;
    cout << "Total constant memory         =" <<  devProp.totalConstMem << endl;
    cout << "Texture alignment             =" <<  devProp.textureAlignment << endl;
    cout << "Concurrent copy and execution =" <<  (devProp.deviceOverlap ? "Yes" : "No")  << endl;
    cout << "Number of multiprocessors     =" <<  devProp.multiProcessorCount << endl;
    cout << "Kernel execution timeout      =" <<  (devProp.kernelExecTimeoutEnabled ? "Yes" : "No")  << endl;
    cout << endl;
}
 
bool cuda_init() {
    // Number of CUDA devices
    int devCount;
    cudaDeviceProp devProp;

    cout << endl;
    cout << "==== CUDA init ====" << endl;
    cudaGetDeviceCount(&devCount);
    cout << "CUDA Device Query...";
    cout << " there are " << devCount << " CUDA devices.\n";
 
 	if ((devCount <= 0) || (devCount > 4)) return false;
 	
    // Iterate through devicess
    for (int i = 0; i < devCount; ++i)
    {
        // Get device properties

        cudaGetDeviceProperties(&devProp, i);
        //printDevProp(i, devProp);
        cout << "GPU " << i << ": " << devProp.name << ", compute capability ";
        cout << devProp.major << "." << devProp.minor << endl;
    }

    Parameters& params = Parameters::get_instance();
    if (params.gpu_selected != Parameters::NO_GPU_SELECTED) {
    	cout << "select GPU " << params.gpu_selected << endl;
    	cudaSetDevice(params.gpu_selected);
    	cudaGetDeviceProperties(&devProp, params.gpu_selected);
    } else {
    	cout << "select default GPU" << endl;
    	cudaGetDeviceProperties(&devProp, 0);
    }
    cout << "gpu_name=" << devProp.name << endl;

 	return true;
}
