/*
 * cpu_chrono.cpp
 *
 *  Created on: Jan 29, 2014
 *      Author: richer
 */

#include "cpu_chrono.h"

CPUChrono::CPUChrono() {
	start();
	stop();
}

void CPUChrono::start() {
	clock_gettime(CLOCK_MONOTONIC, &cpu_chrono_start);
}

void CPUChrono::stop() {
	clock_gettime(CLOCK_MONOTONIC, &cpu_chrono_stop);
}

double CPUChrono::elapsed() {
	return double (cpu_chrono_stop.tv_sec - cpu_chrono_start.tv_sec) +
			(cpu_chrono_stop.tv_nsec - cpu_chrono_start.tv_nsec)/1e9;
}

void CPUChrono::display(ostream& out) {
	out << elapsed();
}



