#!/bin/sh
# find best threads per block for each n and k

d_results=results

if test $# -ne 3 ; then
	echo "error: gpu expected !"
	echo " "
	echo "possible gpus are:"
	echo "------------------"
	ls ${d_results}/gpu_*.txt | cut -d'_' -f2 | uniq
	exit 1
fi

gpu=$1
#architecture 32 or 64
arch=$2
# data size
dasz=$3

f_output="${d_results}/best_gpu_${gpu}_${arch}_${dasz}.txt"
rm -rf $f_output
f_tmp="tmp/tmp.txt"
f_valid_threads="tmp/valid_threads.txt"

# number of taxa
N="64 128 256 512"
# sizes
K="1024 2048 4096 8192 16384 32768 131072 262144"


for n in $N ; do
	for k in $K ; do 
		#echo "grep \"^${n}; ${k};\" ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}*.txt | cut -d';' -f3 | tr -d ' '"
		grep "^${n}; ${k};" ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}*.txt | cut -d';' -f3 | tr -d ' ' >$f_tmp
		#exit 1;
		min_index=`cat $f_tmp | awk -f min_index.awk | cut -d';' -f1`
		#echo $min_index
		x=`grep "^${n}; ${k};" ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}*.txt | head -${min_index} | tail -1 | sed -e "s/.\+_threads_\([0-9]\+\).\+/\1/"`
		min_value=`cat $f_tmp | head -${min_index} | tail -1 | cut -d';' -f2-4`
		echo "$n;$k;${min_index};$x;${min_value}" >> $f_output		
	done
done
cat $f_output

f_freq="tmp/frequency.txt"
rm -rf $f_freq
f_freq_csv="tmp/frequency.csv"
rm -rf $f_freq_csv


echo "===========***"
cat $f_output | cut -d';' -f4 | sort | uniq -c > $f_freq
cat $f_freq

cat $f_freq | sed -e  "s/^[ \t]\+\([0-9]\+\)[ \t]\+\([0-9]\+\)/\2;\1/g" >$f_freq_csv


for k in $K ; do 
	echo "===== $k ====="
	for n in $N ; do
		x=`grep -E "$n; $k;" ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}_*.txt | sort -t ';' --key=3 | head -3 | cut -d';' -f4 | tr '\n' ' '`
		echo "$x;$N" 
	done
done

echo "==========="
for n in $N ; do
	for k in $K ; do 
		grep "^${n}; ${k};" ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}_*.txt | cut -d';' -f3 | tr -d ' ' >$f_tmp
		min_index=`cat $f_tmp | awk -f min_index.awk | cut -d';' -f1`
		x=`grep "^${n}; ${k};" ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}_*.txt | head -${min_index} | tail -1 | sed -e "s/.\+_threads_\([0-9]\+\).\+/\1/"`
		min_value=`cat $f_tmp | head -${min_index} | tail -1 | cut -d';' -f2-4`
		echo "$n;$k;${min_value}" 		
	done
done
cat $f_output


# find valid threads
rm -rf $f_valid_threads
T="64 128 192 256 288 320 384 400 416 512 768 832 1024"
for t in $T ; do
	if test -f ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}_threads_${t}.txt ; then
		echo "$t" >> $f_valid_threads
	fi
done

# generate html file
f_partial="tmp/partial.txt"
f_min_index="tmp/min_index.txt"
html_file="${d_results}/html/gpu_${gpu}_arch_${arch}_data_${dasz}.html"
f_tmp_html="tmp/tmp_html.txt"
echo "html file $html_file"

rm -rf $html_file

echo "<html>\n<head>" >> $html_file
echo "<link rel=\"stylesheet\" type=\"text/css\" href=\"http://fonts.googleapis.com/css?family=Ubuntu\" />" >> $html_file
cat parameters/html_style_for_table.html  >> $html_file
echo "\n</head>\n<body>" >> $html_file

echo "<table>" >> $html_file
echo "<tr>" >> $html_file
echo "	<th>N</th>" >> $html_file
echo "	<th>K</th>" >> $html_file
for t in `cat $f_valid_threads` ; do
	echo "	<th>$t</th>" >> $html_file
done
echo "	<th>best thread</th>" >> $html_file
echo "</tr>" >> $html_file
for n in $N ; do
	for k in $K ; do 
		echo "<tr>" >> $html_file
		echo "	<td>$n</td>" >> $html_file
		echo "	<td>$k</td>" >> $html_file
		rm -rf $f_partial
		for t in `cat $f_valid_threads` ; do
			v=`grep "^${n}; ${k};" ${d_results}/gpu_${gpu}_arch_${arch}_data_${dasz}_threads_${t}.txt | cut -d';' -f3 | tr -d ' '`
			echo "	<td>$v</td>" >> $html_file
			echo "$v" >> $f_partial
		done
		cat $f_partial | awk -f min_index.awk >$f_min_index
		m=`cat $f_min_index | cut -d';' -f1`
		r=`cat $f_min_index | cut -d';' -f2`
		t=`cat $f_valid_threads | head -$m | tail -1`
		echo "	<td>$t</td>" >> $html_file
		echo "</tr>" >> $html_file
		
		cat $html_file | sed -e "s/<td>$r<\/td>/<td class=\"best\">$r<\/td>/" > $f_tmp_html
		mv  $f_tmp_html $html_file		
	done
done		
echo "<tr>" >> $html_file
echo "  <td colspan=\"2\">frequency</td>" >> $html_file
for t in `cat $f_valid_threads` ; do
	x=`cat $f_freq_csv | grep "^$t" | cut -d';' -f2`
	if test -z "$x" ; then
		echo "  <td>0</td>" >> $html_file
	else
		echo "  <td>$x</td>"	>> $html_file
	fi
done
echo "  <td>--</td>" >> $html_file
echo "</tr>" >> $html_file
echo "</table>" >> $html_file

echo "<ul>" >> $html_file
echo "  <li><b>N</b>: number of sequences (=taxa)</li>" >> $html_file
echo "  <li><b>K</b>: length of a sequences</li>" >> $html_file
echo "  <li><b>" >> $html_file
cat $f_valid_threads | tr '\n' ',' >> $html_file
echo "</b>: threads</li>" >> $html_file
echo "</ul>" >> $html_file
echo "</body>\n</html>" >> $html_file
