# ###################################################################
#
#       Program: tsp_path.py
#        Author: Jean-Michel Richer 
#  Organisation: Computer Science Department 
#                Faculty of Science
#                University of Angers
#                2 Boulevard Lavoisier
#                49045 Angers Cedex 01
#                France
#         Email: jean-michel.richer@univ-angers.fr
# Creation date: April, 2021
#  Modification: May, 2021
#
# ###################################################################
# 
# Aim:
#
#    This program is part of a project called TSP Visualizer
#    for Travelling Salesman Problem Visualizer that enables
#    to graphically display a solution of the TSP problem.
#    This class represents a Path.
#
# Objectif :
#
#    Ce programme fait partie d'un projet nommé TSP Visualizer
#    pour Visualiseur du problème du Voyageur de Commerce appelé
#    Travelling Salesman Problem en anglais. Ce programme permet
#    de représenter graphiquement une solution d'une instance
#    de ce problème.
#    Cette class permet de représenter un chemin.
#
# ###################################################################
#
# License
#
#    This program is a free software you can use, modifiy and 
#    redistribute it for non profitable use. If you use this
#    code please cite the program as TSP Visualizer and the 
#    author's name.
#    Please inform the author of possible bugs or evolution 
#    requests.
#
# Licence
#
#    Ce programme est un logiciel libre que vous pouvez utiliser, 
#    modifier et redistribuer pour un usage non lucratif. Si vous
#    utilisez ce code, merci de bien vouloir citer le nom du projet
#    TSP Visualizer et le nom de l'auteur. 
#    Merci d'informer l'auteur de bogues éventuels ou de demandes 
#    d'évolution.
#
#
# ###################################################################

# ===================================================================
#   On définit un chemin (configuration) comme la liste des villes 
#   parcourues et le coût qui lui   est associé
# ===================================================================

class Path( object ):

    """
    CLASS
        This class helps represent a Path which is the list of 
        cities visited and the distance travelled
    """
    
    # =====================================================
    # Constructeur étant donné le chemin sous forme de
    # liste d'entiers qui représentent les villes ainsi
    # que la distance qui en résulte
    # =====================================================
    
    def __init__( self, chemin, distance ):
    
        """
        WHAT
            Constructor given the path as a list of integers that 
            represent the cities and the resulting distance
        
        PARAMETERS
            - chemin (list of int): path as the order of the cities 
            visited
            - distance (int): distance of the path
        """
        
        self.chemin = chemin
        self.distance = distance

    # =====================================================
    # Représente le chemin sous forme de texte
    # =====================================================
    
    def __str__( self ):

        """
        WHAT
            Representation of Path as a string
            
        RETURN
            A string made of the list of cities which are integers
            followed by the distance of the path    
        """
        
        return str( self.chemin ) + ", " + str( self.distance )
    
    # =====================================================
    # Réalise une copie du Path
    # =====================================================
    
    def copy( self ):
    
        """
        WHAT
            Create a copy of the path
            
        RETURN
            Copy of the path    
        """
        return type(self)( self.chemin.copy(), self.distance )


