# ###################################################################
#
#       Program: ez_pygame_usage_example.py
#        Author: Jean-Michel Richer
#  Organisation: Computer Science Department 
#                Faculty of Science
#                University of Angers
#                2 Boulevard Lavoisier
#	             49045 Angers Cedex 01
#                France
#         Email: jean-michel.richer@univ-angers.fr
# Creation date: April, 2021
#  Modification: May, 2021
#
# ###################################################################
# 
# Aim:
#
#    This program is a small example that demonstrates how to
#    use the ez_pygame layer. It displays a ball that bounces 
#    on the edges of the window. 
#
# Objectif :
#
#    Ce programme est un exemple simple qui montre comment utiliser
#    la surcouche ez_pygame. On affiche une balle qui rebondit sur 
#    les bords de la fenêtre
#
# ###################################################################
#
# License
#
#    This program is a free software you can use, modifiy and 
#    redistribute it for non profitable use. 
#
# Licence
#
#    Ce programme est un logiciel libre que vous pouvez utiliser, 
#    modifier et redistribuer pour un usage non lucratif. 
#
# ###################################################################

import pygame
from pygame.locals import *
import ez_pygame as ep
import ez_pygame_fonts_manager as fm
import random

# ===================================================================
# Main variables
# ===================================================================

#
# Window width and height
#
WINDOW_WIDTH = 800
WINDOW_HEIGHT = 600

#
# Colors (Roland Garros white, orange and green)
#
RG_WHITE  = (217,223,226)
RG_ORANGE = (0xc8, 0x62, 0x2f)
RG_GREEN  = (0x22, 0x3f, 0x34)

#
# Create pygame window and register fonts
# 

gui = ep.EZPygame( "Example", WINDOW_WIDTH, WINDOW_HEIGHT, RG_ORANGE )

fonts_definition = {
	"pm" : { "ttf_file": "fonts/PermanentMarker-Regular.ttf", "sizes": [14,24] }
}

fma = fm.FontsManager( fonts_definition )
gui.set_font_manager( fma )

#
# Ball data: position, radius, direction
# 

x_ball = random.randint( 20, 200 ) 
y_ball = random.randint( 20, 200 ) 
x_dir = 4
y_dir = 4
ball_radius = 10
nbr_bounces = 0


# ===================================================================
# Function in charge of the rendering that draws the ball and moves 
# it and is in charge of the rebound.
# We also print as text the number of rebounds and a message to
# indicate how to leave the window
# ===================================================================
def rendering_function( gui ):
	global x_ball, y_ball, ball_radius, x_dir, y_dir, nbr_bounces

	#
	x_ball += x_dir
	y_ball += y_dir
	
	if x_ball > WINDOW_WIDTH or x_ball < 0:
		nbr_bounces += 1
		x_dir = -x_dir

	if y_ball > WINDOW_HEIGHT or y_ball < 0:
		nbr_bounces += 1
		y_dir = -y_dir
		
		
	pygame.draw.circle( gui.window, RG_WHITE, (x_ball,y_ball), ball_radius )
	
	s = "bounces = " + str( nbr_bounces )
	gui.draw_text_center( s, 10, RG_GREEN, RG_ORANGE, font_name="pm24" )
	gui.draw_text( "Ctr-C, F10 or ESC to quit", 10, WINDOW_HEIGHT-22, RG_WHITE, font_name="pm14" )


# ===================================================================
# Function in charge of the events: it will close the window if
# we press on Ctrl-C, F10 or ESC or if we quit the window by
# a click on 'x' in the window border 
# ===================================================================
def events_handler( gui ):
	for event in pygame.event.get():
		if event.type == QUIT:
			gui.stop = True
			
		if event.type == KEYDOWN:
			# Ctrl-C to leave game
			if event.key == pygame.K_c and pygame.key.get_mods() & pygame.KMOD_CTRL:
				gui.stop = True
				return None
			
			if event.key == pygame.K_F10:
				gui.stop = True
				return None
				
			if event.key == K_ESCAPE:
				gui.stop = True
				return None	

#
# Call of the main function
#

gui.render( rendering_function, events_handler )


