# ###################################################################
#
#       Program: color_model.py
#        Author: Jean-Michel Richer
#  Organisation: Computer Science Department 
#                Faculty of Science
#                University of Angers
#                2 Boulevard Lavoisier
#	             49045 Angers Cedex 01
#                France
#         Email: jean-michel.richer@univ-angers.fr
# Creation date: April, 2021
#  Modification: May, 2021
#
# ###################################################################
# 
# Aim:
#
#    This program is an implementation of a class that allows to 
#	 represent a color model, that is to say, a set of colors that 
#	 ensure some consistency in the display of different elements 
# 	 that we must represent. It is part of the ez_pygame project.
#
# Objectif :
#
#    Ce programme est une implantation d'une classe qui permet de
#    représenter un modèle de couleurs, c'est à dire un ensemble de
#    couleurs qui assurent une cohérence lors de l'affichage des
#	 différents éléments que l'on doit représenter. Il fait partie
#    du projet appelé ez_pygame.
#
# ###################################################################
#
# License
#
#    This program is a free software you can use, modifiy and 
#    redistribute it for non profitable use. If you use this
#    code please cite the library (ez_pygame) and author.
#    Please inform the author of possible bugs or evolution 
#    requests.
#
# Licence
#
#    Ce programme est un logiciel libre que vous pouvez utiliser, 
#    modifier et redistribuer pour un usage non lucratif. Si vous
#    utilisez ce code, merci de bien vouloir citer le nom de la
#    librairie (ez_pygame) et l'auteur. 
#    Merci d'informer l'auteur de bogues éventuels ou de demandes 
#    d'évolution.
#
#
# ###################################################################


# ===================================================================
# Modèle de couleurs pour une application qui permet de choisir 
# entre différents modèles
# ===================================================================

class ColorModel( object ):
	
	"""
	Define a color model composed of several colors that will define
	the color of the background, foreground and other elements
	"""
	
	# =====================================================
	# Constructeur avec noms des couleurs sous forme
	# d'une chaine de caractère, chaque nom étant séparé
	# par la barre verticale (pipe '|') 
	# =====================================================
	
	def __init__( self, colors_names ):
	
		"""
		Constructor given colors' names as a string where
		each name is separated by a	pipe character '|'
		"""
		
		self.color_model = {}
		self.model_name = "_"
		self.models_names = [ ]
		self.index = -1
		self.colors_names = colors_names.split( "|" )

	# =====================================================
	# Retourne le nom des modèles
	# =====================================================
		
	def get_models_names( self ):
	
		"""
		Get names of color models
		"""
		
		return self.color_model.keys()

	# =====================================================
	# Ajoute un modèle de couleur
	# =====================================================
			
	def add( self, name, list_of_colors ):
	
		"""
		Add a new color model
		
		Parameters
		----------
		name: string
			name of color model
		list_of_colors: list of colors
			list of colors that define the model
		"""
		
		self.color_model[name] = list_of_colors
		self.models_names = list( self.color_model.keys() )

	# =====================================================
	# Définit le modèle de couleur courant
	# =====================================================
		
	def set_model( self, name ):
	
		"""
		Set current color model
		
		Parameters
		----------
		name : string
			name of an existing color model
		"""
		
		self.model_name = name	
		self.index = self.models_names.index( name )
		
	# =====================================================
	# Retourne la couleur qui correspond au nom passé en
	# paramètre pour le modèle courant
	# =====================================================
		
	def get( self, flavor ):
	
		"""
		Return color that corresponds to the flavor in the
		current color model
		
		Parameters
		----------
		
		"""
		index = self.colors_names.index( flavor )
		return self.color_model[ self.model_name ][ index ]


	# =====================================================
	# Passe au modèle de couleur suivant
	# =====================================================

	def next( self ):
	
		"""
		Change current color model to the next color model
		in the order defined by the addition of color models
		"""
		
		self.index = (self.index + 1) % len( self.models_names )
		self.model_name = self.models_names[ self.index ]






