# TSP Visualizer 1.1

This project aims at graphically representing a solution of the
Travelling Salesman problem. The basic data of the problem are
the number of cities and their distances as a matrix.

To have a better understanding we add the names of the cities
and their positions on a map. You can also define the path that
needs to be displayed or provide it as a command line argument.

There are three examples within this project in the *data*
subdirectory. The solutions have been found using the **simulated
annelaing** algorithm provided with this project:

* 13 cities in USA with a minimum distance of 7293 miles
* 32 cities in France with a minimum distance of 4753 kms
* 100 cities in France with a minimum distance of 7508 kms

## 1. Installation

This project is written in **python** and relies on **pygame** for the
graphics part. You will need to install pygame 2.0 for the 
project to function.
The current version I am using on my computer (Linux Ubuntu 20.04) 
is Anaconda with python 3.8.5 and pygame 2.0.0.dev6 (SDL 2.0.10).

### 1.1 Anaconda

If you are using Anaconda, please also install the following packages:

```shell
$ conda update -n base -c defaults conda
$ conda install -c conda-forge pyperclip
```

The **pyperclip** package is necessary in order to use the clipboard and copy
a solution inside it using the F9 key.

### 1.2 Minizinc

[MiniZinc](https://www.minizinc.org/) is a free and open-source constraint modeling language and can
be used with solvers like Chuffed or Gecode.

```shell
$ conda install minizinc
```

or use:

```shell
$ pip install minizinc
```


### 1.3 LKH

LKH is an effective C implementation from **K. Helsgaun** of the Lin-Kernighan heuristic for solving the travelling salesman problem. You can download it  [here](http://webhotel4.ruc.dk/~keld/research/LKH/) as version 2.0.9 of July 2018.

To install LKH, type the following:

```shell
tar xvfz LKH-2.0.9.tgz
cd LKH-2.0.9
make
```

## 2. Usage

### 2.1 Basic usage with input eztsp file

From the command line you have to provide a file of data in **eztsp format**, for
example :

```
$ python tsp_visualizer.py -i data/france_32.eztsp
```
or

```
$ python tsp_visualizer.py --input=data/france_32.eztsp
```

### 2.2 Path (-p or --path=)

You can also specify a path to display. For example with the file 
composed of US cities:

```
$ python tsp_visualizer.py --input=data/usa_13.eztsp -p "1, 8, 3, 4, 9, 13, 7, 5, 2, 12, 11, 6, 10"
```

This will replace the path defined in the file "data/usa_13.eztsp".

### 2.3 Resolution with LKH (-k or --lkh=)

To use LKH as a solver you have to provide the binary:

```
$ python tsp_visualizer.py --input=data/usa_13.eztsp -k /<path>/LKH-2.0.9/LKH
```
or 
```
$ python tsp_visualizer.py --input=data/usa_13.eztsp --lkh=/<path>/LKH-2.0.9/LKH
```

### 2.4 Resolution with Minizinc (-m or --minizinc=)

If you use Minizinc to solve the problem you can specify two parameters:
- the name of the solver
- the time dedicated to the resolution

In order to you the chuffed solver, you can add:
```
$ python tsp_visualizer.py -m chuffed
```

To allow the chuffed solver to search for 60 seconds:
```
$ python tsp_visualizer.py -m chuffed,60
```

To allow the gecode solver to search for 120 seconds:
```
$ python tsp_visualizer.py --minizinc=gecode,120
```
To allow the default solver (chuffed) to search for 20 seconds:
```
$ python tsp_visualizer.py --minizinc=,20
```


## 3. Commands of the interface

When you start the program you see the help menu.
You can press Ctrl-C, F10 or Alt+F4 to quit the program.

- F1 for the help menu
- F2 to view path as a graph (graph mode)
- F3 to view path as a list of cities (cities mode)
- F4 for the about window 
- F5 to change color model
- F6 to show / hide cities' names (in view mode F2)
- F7 to show / hide distances (in view mode F2)
- F8 to move the "Distance=" message
- F9 to print path on console and copy to clipboard (in view mode F2)
- F10, Ctrl-C to quit
- F11 to change the size of the window
- F12 to save the path view as an image (in graph mode F2)
- 'L' display list of cities
- 'I' Resolution of the problem based on an iterated local seach algorithm
- 'S' Resolution of the problem based on a simulated annealing algorithm 
- 'K' Resolution of the problem based on LKH 
- 'M' Resolution of the problem based on Minizinc

To modify the path in graph mode (F2) :

- Click on a first city and another one to link them
- Right click in graph mode to go back to the previous path

## 4. EZ TSP File Format

The file that contains information about the cities and distances is 
called EZ TSP and has .eztsp extension. The comments are introduced
by the hashtag ('#') symbol at the beginning of a line and the rest
of the line is considered as a comment.

The file contains the following sections :

### 4.1 COUNT

The COUNT section is required and defines the number of cities:

```
COUNT [
	13
]
```

### 4.2 CITIES

The CITIES section is optional and helps define the names of the cities where
there should be one city per line:

```
CITIES [
	New York, NY
	Los Angeles, CA
	Chicago, IL
	Minneapolis, MN
	Denver, CO
	Dallas, TX
	Seattle, WA
	Boston, MA
	San Francisco
	St. Louis, MI
	Houston, TX
	Phoenix, AZ
	Salt Lake City, UT
]
```

If cities' names are not provided they are generated by the program.

### 4.3 DISTANCES

The DISTANCES section is required and describe the distances between distances. 
This is a full symmetric matrix.

```
DISTANCES [
	0, 2451, 713, 1018, 1631, 1374, 2408, 213, 2571, 875, 1420, 2145, 1972
	2451, 0, 1745, 1524, 831, 1240, 959, 2596, 403, 1589, 1374, 357, 579
	713, 1745, 0, 355, 920, 803, 1737, 851, 1858, 262, 940, 1453, 1260
	1018, 1524, 355, 0, 700, 862, 1395, 1123, 1584, 466, 1056, 1280, 987
	1631, 831, 920, 700, 0, 663, 1021, 1769, 949, 796, 879, 586, 371
	1374, 1240, 803, 862, 663, 0, 1681, 1551, 1765, 547, 225, 887, 999
	2408, 959, 1737, 1395, 1021, 1681, 0, 2493, 678, 1724, 1891, 1114, 701
	213, 2596, 851, 1123, 1769, 1551, 2493, 0, 2699, 1038, 1605, 2300, 2099
	2571, 403, 1858, 1584, 949, 1765, 678, 2699, 0, 1744, 1645, 653, 600
	875, 1589, 262, 466, 796, 547, 1724, 1038, 1744, 0, 679, 1272, 1162
	1420, 1374, 940, 1056, 879, 225, 1891, 1605, 1645, 679, 0, 1017, 1200
	2145, 357, 1453, 1280, 586, 887, 1114, 2300, 653, 1272, 1017, 0, 504
	1972, 579, 1260, 987, 371, 999, 701, 2099, 600, 1162, 1200, 504, 0
]
```

### 4.4 PATH

The PATH section is optional and helps define the path that needs to be 
displayed. Cities are separated by commas:

```
PATH [
	1, 8, 3, 4, 5, 13, 7, 9, 2, 12, 11, 6, 10
]
```

Note that the first city as index 1. If the path is not provided it is
generated as [1, 2, ..., N-1, N].

### 4.5 WINDOW

The WINDOW section is optional and helps define the size of the window
that is used to display the path. The first parameter is the *width* of the
window followed by the *height* :

```
WINDOW [
	1053, 540
]
```

### 4.6 POSITIONS

The POSITIONS section is optional and let's one define the positions of the
cities in the window used to display the path. Each line is related to a city
and we must define the x and y positions :


```
# (x,y)
POSITIONS [
	922, 242
	244, 371
	715, 208
	628, 153
	448, 258
	574,395
	182, 92
	967, 208
	183, 300
	675, 282
	597, 448
	341, 383
	342, 240
]
```

If the positions are not provided they are generated on a circle.

### 4.7 BACKGROUND

The BACKGROUND section is optional and can be defined to have a better
understanding of the path by placing cities on the background picture
which can be a map of a country for example (See data/usa_13.eztsp).

```
BACKGROUND [
	backgrounds/usa.png
]
```

Note that if you use the BACKGROUND then the positions of the cities
defined in the POSITIONS section must correspond to the pixels in the
background image.






