#pragma once
#include <iostream>
#include <chrono>

typedef std::chrono::time_point<std::chrono::system_clock> time_measure;

class Timer {
private:
	time_measure _start, _stop;
	
public:
	Timer();
	
	void start();
	
	void stop();
	
	double seconds();
	
};

#define timeit(stream, message, code) \
	{ \
		Timer a_timer; \
		a_timer.start(); \
		code \
		a_timer.stop(); \
		stream << "- timeit:" << message << "=" << a_timer.seconds() << " seconds" << std::endl; \
	}
		
	
