#pragma once

#include <iostream>
using namespace std;

#include <cuda.h>

// Easy Cuda Valid function call
#define ezc_valid(value) {     \
    cudaError_t err = value; \
    if (err != cudaSuccess) {       \
            cerr << endl; \
            cerr << "============================================\n"; \
            cerr << "Error: " << cudaGetErrorString(err) << " at line "; \
            cerr << __LINE__ << " in file " <<  __FILE__;   \
            cerr <<  endl; \
            exit(EXIT_FAILURE); \
    } \
}

// Easy Cuda Valid Kernel call
#define ezc_valid_kernel() { \
    cudaError_t err = cudaGetLastError(); \
    if (err != cudaSuccess)  { \
            cerr << endl; \
            cerr << "============================================\n"; \
            cerr << "Kernel Error: " << cudaGetErrorString(err) << " at line "; \
            cerr << __LINE__ << " in file " <<  __FILE__;   \
            cerr <<  endl; \
            exit(EXIT_FAILURE); \
    } \
}


#define GPU_to_CPU cudaMemcpyDeviceToHost
#define CPU_to_GPU cudaMemcpyHostToDevice

#define ezc_malloc( var_on_gpu, type, size ) \
	ezc_valid( cudaMalloc( (void **) &var_on_gpu, size * sizeof(type) ) )

#define ezc_memcpy_to_gpu( var_on_gpu, var_on_cpu, type, size) \
	ezc_valid( cudaMemcpy( var_on_gpu, var_on_cpu, size * sizeof(type), CPU_to_GPU ) );

#define ezc_memcpy_to_cpu( var_on_cpu, var_on_gpu, type, size) \
	ezc_valid( cudaMemcpy( var_on_cpu, var_on_gpu, size * sizeof(type), GPU_to_CPU ) );

