/*
 * gol_base.h
 *
 *  Created on: Oct 10, 2014
 *      Author: richer
 */

#ifndef GOL_BASE_H_
#define GOL_BASE_H_

#include <iostream>
#include <stdint.h>
using namespace std;

/* type of cells either int (int32_t) or small int (int16_t) or byte (int8_t) */
typedef uint8_t u8;
typedef int8_t i8;

#define CellType i8

#define MAX_FRAMES 501
#define SRAND_SEED 19702013


#define ALIVE 1
#define DEAD 0

/**
 * count number of cells alive
 * @param cells matrix of cells represented as a 1D-array
 * @param bs board size
 */
int cells_alive(CellType *cells, int bs);

/**
 * print cells
 * @param cells matrix of cells represented as a 1D-array
 * @param bs board size
 */
void cells_print(CellType *cells, int bs);

#endif /* GOL_BASE_H_ */
