#include "gol_base.h"

int cells_alive(CellType *cells, int bs) {
	int alive = 0;

	for (int y = 0; y < bs; y++) {
		for (int x = 0; x < bs; x++) {
			alive += (int) cells[y * bs + x];
		}
	}
	return alive;
}

void cells_print(CellType *cells, int bs) {
	for (int y = 0; y < bs; y++) {
		for (int x = 0; x < bs; x++) {
			if (cells[y*bs+x] == 1) {
				cerr << "1";
			} else if (cells[y*bs+x] == 0) {
				cerr << ".";
			} else {
				throw std::runtime_error("value not allowed");
			}
		}
		cerr << endl;
	}
}
