#ifndef GL_IMAGE_H
#define GL_IMAGE_H

#include "gl_helper.h"
#include <stdint.h>
#include <string>
#include <fstream>
#include <cstring>

#ifdef LIBPNGPP
#include <png++/generator.hpp>
#include <png++/rgba_pixel.hpp>
#include <png++/writer.hpp>
#endif

typedef struct {
	uint8_t red, green, blue, alpha;
} ImagePoint;

/**
 *
 */
class GLImage {
public:
	int32_t m_width, m_height;
	size_t m_size;
	ImagePoint *m_pixels;
	
	GLImage(int width, int height);
	
	~GLImage() {
		delete [] m_pixels;
	}
	
	ImagePoint *pixels() {
		return m_pixels;
	}
	
	int32_t width() {
		return m_width;
	}
	
	int32_t height() {
		return m_height;
	}
	
	size_t size() {
		return m_size;
	}
	
	void pixel(int x, int y, int r, int g, int b) {
		int offset = y*m_width+x;
		m_pixels[offset].red= r;
		m_pixels[offset].green= g;
		m_pixels[offset].blue= b;
		m_pixels[offset].alpha= 255;
	}
	
	void pixel(int x, int y, int r, int g, int b, int a) {
		int offset = y*m_width+x;
		m_pixels[offset].red= r;
		m_pixels[offset].green= g;
		m_pixels[offset].blue= b;
		m_pixels[offset].alpha= a;
	}
	
	void draw() {
		glClearColor(0,0,0,1);
		glClear(GL_COLOR_BUFFER_BIT);
		glDrawPixels(m_width, m_height, GL_RGBA, GL_UNSIGNED_BYTE, m_pixels);
		glutSwapBuffers();
	}

#ifdef LIBPNGPP
	void save(std::string file_name);


	void save_png(std::string file_name);
#endif
};

#endif

