#!/bin/sh

bin=./bin/matrix_product_release.exe
sizes=`seq 768 256 4100` 

make clean 
echo "build..."
result=`make compiler=gnu distrib=release >/dev/null 2>/dev/null`

if test $? -ne 0 ; then
	echo "Error: could not compile release, please type:"
	echo "\tmake compiler=gnu distrib=release"
	echo "and solve potential errors"
	exit 1
fi

echo "============================"
echo "TESTS for mul1"
echo "============================"

rm -rf results/mul1.txt
for s in $sizes ; do
	/usr/bin/time -f "usertime=%e" $bin mul1 $s >tmp.txt 2>err.txt 
	t=`cat err.txt | grep "usertime=" | cut -d'=' -f2`
	echo "$s $t"
	echo "$s $t"  >> results/mul1.txt
done

echo "============================"
echo "TESTS for mul2"
echo "============================"

rm -rf results/mul2_4.txt
for s in $sizes ; do
	/usr/bin/time -f "usertime=%e" $bin mul2 $s 4 >tmp.txt 2>err.txt 
	t=`cat err.txt | grep "usertime=" | cut -d'=' -f2`
	echo "$s $t"
	echo "$s $t"  >> results/mul2_4.txt
done

echo "============================"
echo "TESTS for mul3"
echo "============================"

rm -rf results/mul3.txt
for s in $sizes ; do
	/usr/bin/time -f "usertime=%e" $bin mul3 $s >tmp.txt 2>err.txt 
	t=`cat err.txt | grep "usertime=" | cut -d'=' -f2`
	echo "$s $t"
	echo "$s $t"  >> results/mul3.txt
done

echo "============================"
echo "TESTS for mul4"
echo "============================"

rm -rf results/mul4_4.txt
for s in $sizes ; do
	/usr/bin/time -f "usertime=%e" $bin mul4 $s 4 >tmp.txt 2>err.txt 
	t=`cat err.txt | grep "usertime=" | cut -d'=' -f2`
	echo "$s $t"
	echo "$s $t"  >> results/mul4_4.txt
done

echo "============================"
echo "TESTS for mul5"
echo "============================"

rm -rf results/mul5_4.txt
for s in $sizes ; do
	/usr/bin/time -f "usertime=%e" $bin mul5 $s 4 >tmp.txt 2>err.txt 
	t=`cat err.txt | grep "usertime=" | cut -d'=' -f2`
	echo "$s $t"
	echo "$s $t"  >> results/mul5_4.txt
done


# try to use MKL
make clean 
echo "build..."
result=`make compiler=intel distrib=release >/dev/null 2>/dev/null`

if test $? -ne 0 ; then
	echo "Error: could not compile release, please type:"
	echo "\tmake compiler=intel distrib=release"
	echo "and solve potential errors"
	exit 1
fi

if test -f $bin ; then

	echo "============================"
	echo "TESTS for mul5 with MKL"
	echo "============================"

	rm -rf results/mul5_mkl_1.txt
	for s in $sizes ; do
		/usr/bin/time -f "usertime=%e" $bin mul5 $s 1 >tmp.txt 2>err.txt
		t=`cat err.txt | grep "usertime=" | cut -d'=' -f2`
		echo "$s $t"
		echo "$s $t"  >> results/mul5_mkl_1.txt
	done

	rm -rf results/mul5_mkl_4.txt
	for s in $sizes ; do
		/usr/bin/time -f "usertime=%e" $bin mul5 $s 4 >tmp.txt 2>err.txt
		t=`cat err.txt | grep "usertime=" | cut -d'=' -f2`
		echo "$s $t"
		echo "$s $t"  >> results/mul5_mkl_4.txt
	done

	gnuplot mul12345_and_mkl.script
	gnuplot mul_mkl.script

else

	gnuplot mul12345.script
fi

echo "=============================================================="
echo "all results are in the directory 'results'"
echo "Type 'eog results.png' to view image file generated by gnuplot"
echo "=============================================================="

rm -rf err.txt tmp.txt

