/*
 * timer.h
 *
 *  Created on: Apr 2, 2015
 *      Author: richer
 */

#ifndef TIMER_H_
#define TIMER_H_

#include <stdint.h>
#include <iostream>
#include <math.h>
#include <chrono>
#include <iomanip>
using namespace std;


namespace base {

/**
 * class used to measure performances of algorithms between two
 * events called start and stop.
 * <ul>
 * 	<li>use start() method to start timer</li>
 * 	<li>use stop() method to stop timer</li>
 * 	</ul>
 */
class Timer {
public:
	/**
	 * definition of type to get results in nano seconds
	 */
	typedef std::chrono::time_point<std::chrono::high_resolution_clock> Time;

	/**
	 * default constructor
	 */
	Timer();

	/**
	 * start chrono and record clocks
	 */
	void start();

	/**
	 * stop chrono and record clocks
	 */
	void stop();

	/**
	 * function that prints timer value
	 * @param out output stream
	 * @return output stream
	 */
	ostream& print(ostream& out);

	/**
	 * friend function used to print timer on output stream
	 * @param out output stream
	 * @param obj timer to print
	 * @return output stream
	 */
	friend ostream& operator<<(ostream& out, Timer& obj) {
		return obj.print(out);
	}

private:
	/**
	 * start time
	 */ 
	Time _start;
	/**
	 * end time
	 */
	Time _stop;
};

}

#endif /* TIMER_H_ */
