/*
 * timer.cpp
 *
 *  Created on: Apr 2, 2015
 *      Author: richer
 */

#include "timer.h"

using namespace base;


Timer::Timer() {
	_stop = _start = std::chrono::high_resolution_clock::now();
}

void Timer::start() {
	_start = std::chrono::high_resolution_clock::now();
}

void Timer::stop() {
	_stop = std::chrono::high_resolution_clock::now();
}

ostream& Timer::print(ostream& out) {
	auto ms = _stop - _start;
	std::chrono::hours   hh = std::chrono::duration_cast<std::chrono::hours>(ms);
	std::chrono::minutes mm = std::chrono::duration_cast<std::chrono::minutes>(ms % chrono::hours(1));
	std::chrono::seconds ss = std::chrono::duration_cast<std::chrono::seconds>(ms % chrono::minutes(1));
	std::chrono::milliseconds msec = std::chrono::duration_cast<std::chrono::milliseconds>(ms % chrono::seconds(1));
	out << setfill('0') << setw(2) << hh.count() << "::"
			<< setw(2) << mm.count() << "::"
			<< setw(2) << ss.count() << "::"
			<< setw(3) << msec.count();

	double total_in_seconds = ss.count() + 60 * mm.count() + 3600 * hh.count();
	out << "," << total_in_seconds;
	return out;
}





