# configure CPPFLAGS and COFLAGS for Intel icpc depending on
# distrib=release, debug or profile
ifeq "$(compiler)" "intel"
CC=icpc
INCS=$(MKL_INC)

arch=$(shell arch)
ifeq "$(arch)" "i686"
LIBS= -openmp -DMKL -L${MKLROOT}/lib/ia32 -lmkl_intel -lmkl_core -lmkl_sequential -lmkl_intel_thread -lmkl_gnu_thread -lmkl_rt -lpthread -lm
endif
ifeq "$(arch)" "x86_64"
LIBS= -openmp -DMKL -DMKL_ILP64 -L${MKLROOT}/lib/intel64 -lmkl_intel_ilp64 -lmkl_core -lmkl_intel_thread -lmkl_sequential -lmkl_rt -lpthread -lm
endif

#default distrib is release
CPPFLAGS=-Wall -std=c++11 -DMKL
COFLAGS=-O2 -xSSE4.2 -funroll-loops -openmp

ifeq "$(distrib)" "debug"
COFLAGS=-ggdb  
endif

ifeq "$(distrib)" "profile"
COFLAGS=-pg 
endif

endif
