# configure CPPFLAGS and COFLAGS for GNU g++ depending on
# distrib=release, debug or profile
ifeq "$(compiler)" "gnu"
CC=g++
LIBS=-fopenmp $(BLAS_LIB) $(GSL_LIB)
INCS=$(BLAS_INC) $(GSL_INC)

#default distrib is release
CPPFLAGS=-Wall -std=c++11 -fmax-errors=4 -DCBLAS $(INCS)
COFLAGS=-O3 -ftree-vectorize -funroll-loops -msse4.2  -fopenmp 

ifeq "$(distrib)" "debug"
COFLAGS=-ggdb 
endif

ifeq "$(distrib)" "profile"
COFLAGS=-O2 -g
endif

endif

