# -------------------------------------------------------------------
# file: makefile
# author: Jean-Michel Richer (jean-michel.richer@univ-angers.fr)
# date: august 2015
# -------------------------------------------------------------------

include $(PROJECT_ROOT_DIR)/makefile.distrib
include $(PROJECT_ROOT_DIR)/makefile.libraries

#OBJECT_DIR=$(PROJECT_ROOT_DIR)/build/obj/$(PROJECT_VERSION)/$(MODULE)/$(DISTRIB)
INCLUDE_DIR=$(PROJECT_ROOT_DIR)/include/$(PROJECT_VERSION)
LIBRARY_DIR=$(PROJECT_ROOT_DIR)/build/lib/$(PROJECT_VERSION)/$(DISTRIB)
TESTS_DIR=$(PROJECT_ROOT_DIR)/build/tests/$(PROJECT_VERSION)/$(MODULE)/$(DISTRIB)

SRCS=$(shell ls *.cpp)

TESTS_EXE=$(addprefix $(TESTS_DIR)/,$(subst .cpp,.exe,$(SRCS)))

LIBRARIES=$(shell ls $(LIBRARY_DIR)/*.a)

TARGET=$(TESTS_EXE)

all: header create_directory $(TARGET) 
	@echo "done"

header:
	@echo " " ; \
	echo "================================" ; \
	echo "generate tests for module $(MODULE)" ; \
	echo "================================" ; \
		
create_directory:
	@mkdir -p $(TESTS_DIR)


$(TESTS_DIR)/%.exe: %.cpp $(LIBRARIES)
	@$(eval NS := $(shell echo $(PROJECT_ROOT_DIR)/bin/tests | tr -c -d '/' | wc -m)) 
	@$(eval FILE := $(shell echo $@ | cut -d'/' -f$(NS)-20))
	@echo "-- compile $< --> $(FILE)"
	@g++ $< -o $@ $(CFLAGS) $(OFLAGS) $(LIBRARIES) -I$(INCLUDE_DIR) -I$(CPPUNIT_INCLUDE_DIR) $(CPPUNIT_LIBRARY)

check: $(TARGET)
	@echo `date` >$(UNIT_TESTS_FILE)
	@for module in $(MODULES) ; do \
		echo "run tests for "$$module ; \
		cd build/tst/$(CFG_VERSION)/$(CFG_DISTRIBUTION)/$$module ; \
		for f in `ls test*.exe` ; do \
			echo "- "$$f ; \
			./$$f >>$(UNIT_TESTS_FILE) ; \
		done ; \
		cd $(PROJECT_DIR) ; \
	done
	@echo "RESULTS"
	@cat $(UNIT_TESTS_FILE) | grep "Failure" || true

clean:
	@rm -rf  $(TARGET) 


