#include "base/command_line.h"
using namespace base;
#ifdef PROFILE
#include "gperftools/profiler.h"
#endif

// number of loops for each calculation
#define MAX_LOOPS 2000

// first dimension of arrays (number of rows)
#define SIZE1 1000
// second dimension of arrays (number of columns)
#define SIZE2 2000

// type of array
#define TYPE float

/**
 * allocate matrix of size : SIZE1*SIZE2*sizeof(TYPE)
 */
TYPE **allocate_array() {
  int i;
  TYPE **array;

  array=(TYPE **) calloc(SIZE1,sizeof(TYPE *));
  for (i=0;i<SIZE1;++i) {
    array[i]=(TYPE*) calloc(SIZE2,sizeof(TYPE));
  }
  return array;
}

/**
 * fill matrix with random values
 */
void fill_array(TYPE **a) {
  int i, j;

  for (i=0;i<SIZE1;++i) {
    for (j=0;j<SIZE2;++j) {
      a[i][j] = rand() % 1000;
    }
  }
}

/**
 * function that is called 
 * MAX_LOOPS * SIZE1 / 2 times by proc21
 * MAX_LOOPS * SIZE1 / 2 times by proc21
 *
 */
void proc3(TYPE *c, TYPE *a, TYPE *b, int k) {
  int j;

  for (j=0;j<SIZE2;++j) {
    c[j]=a[j]*k+b[j];
  }
}

/**
 * first calculation
 */
void proc21(TYPE **a, TYPE **b) {
  int i;

  for (i=0;i<SIZE1;i+=2) {
    proc3(a[i+1],a[i],b[i],3);
  }
}

/**
 * second calculation
 */
void proc22(TYPE **a, TYPE **b) {
  int i;

  for (i=0;i<SIZE1;i+=2) {
    proc3(b[i+1],a[i],b[i],-5);
  }
}


/**
 * function that calls 
 * MAX_LOOPS times proc21 
 * MAX_LOOPS times proc22 
 */
void proc1(TYPE **a, TYPE **b) {
  int i;

  for (i=0; i<MAX_LOOPS; ++i) 
    proc21(a,b);
  for (i=0; i<MAX_LOOPS; ++i) 
    proc22(a,b);

}
      
int main(int argc, char *argv[]) {	

	try {
		srand(time(nullptr));
		TYPE **a1, **a2;

		// allocate matrices
		a1 = allocate_array();
		a2 = allocate_array();

		// fill matrices
		fill_array(a1);
		fill_array(a2);

		// call main function for computations
#ifdef PROFILE
		ProfilerStart("/home/richer/profile.prof");
#endif		
		proc1(a1,a2);
#ifdef PROFILE
		ProfilerStop();
		ProfilerFlush();
#endif		
				
	} catch(Exception& e) {

		cerr << Terminal::line1 << endl;
		cerr << "Exception raised in program " << endl;
		cerr << Terminal::line2 << endl;
		cerr << e.what();
		cerr << Terminal::line1 << endl;
	}

	exit(EXIT_SUCCESS);
}

