#include "base/command_line.h"
#include "maths/statistics.h"
using namespace base;
using namespace maths;
#include "gperftools/profiler.h"

bool help_flag = false; 
u32 data_size = 10;
u32 data_lower_bound = 1;
u32 data_upper_bound = 100;

string output_file_name = "";

u32 compute_id = 0;
vector<string> compute_options = {
		"avg", "std", "min", "max", "all"
};
  
    
void process1() {
	vector<int> data(data_size);
	
	generate(data.begin(), data.end(), []() {
		return data_lower_bound + rand() % (data_upper_bound - data_lower_bound + 1);
	});
	
	u32 print_flags = 0;
	switch(compute_id) {
	   case 0: print_flags = PRINT_AVG; break;
	   case 1: print_flags = PRINT_AVG | PRINT_SDV; break;
	   case 2: print_flags = PRINT_AVG | PRINT_SDV | PRINT_MIN; break;
	   case 3: print_flags = PRINT_AVG | PRINT_SDV | PRINT_MAX; break;
	   case 4: print_flags = PRINT_ALL; break;
	}
	
	Statistics<int, f32> stats(data, print_flags);
	stats.compute();
	cout << stats << endl;
	
}

void process2() {
	float *x = new float[ 100000 ];
	float *y = new float[ 100000 ];
	
	for (int i=0; i<100000; ++i) {
		x[i] = 1.1;
		y[i] = 0.8; 
	}
	
	for (int r=0; r < 1000000; ++r) {
		for (int i=0; i<100000; ++i) {
			x[i] += y[i];
		}
	}
	
	float sum = 0.0;
	for (int i=0; i<100000; ++i) {
		sum += x[i];
	}
	cout << "sum = " << sum << endl;
	
	delete [] x;
	delete [] y;
}
    
  
int main(int argc, char *argv[]) {	
	CommandLine cl(argc, argv); 

	try {
		cl.add(new FlagArgument("help", 'h', "help mode", &help_flag));
		cl.add(new NaturalArgument("size", 's', "set number of values generated", &data_size));
		cl.add(new NaturalArgument("lower-bound", 'l', 
			"set lower bound of values generated", &data_lower_bound));
		cl.add(new NaturalArgument("upper-bound", 'u', 
			"set upper bound of values generated", &data_upper_bound));
		
		cl.add(new OptionsArgument("compute", 'c', "define what needs to be computed", 
			&compute_id, &compute_options));
		cl.add(new StringArgument("output-file", 'o', "output file", &output_file_name));

		// --------------------------------------------------------------
		// parse command line arguments
		// --------------------------------------------------------------
		cl.parse();
		cl.set_show_synopsis(false);
		
		// check values
		if (data_size < 10) {
			throw_c(EXC_BAD_VALUE, "you need to have enough data, chose size >= 10");
		} 
		
		if (data_lower_bound >= data_upper_bound) {
			throw_c(EXC_BAD_VALUE, "lower bound should be smaller than upper bound");
		} 
		
		srand(time(nullptr));
		ProfilerStart("/home/richer/profiler.txt");
		process1();
		process2();
		ProfilerStop();
		ProfilerFlush();
		
	} catch(Exception& e) {
		cl.print_synopsys(cout, "prog1");

		cerr << Terminal::line1 << endl;
		cerr << "Exception raised in program " << cl.get_program_name() << endl;
		cerr << Terminal::line2 << endl;
		cerr << e.what();
		cerr << Terminal::line1 << endl;
	}

	exit(EXIT_SUCCESS);
}

