/*
 * strings.cpp
 *
 *  Created on: Apr 2, 2015
 *      Author: richer
 */

#include "strings.h"

using namespace base;

void Strings::trim_right(string& s, const string& pattern) {
	string::size_type pos = s.find_last_not_of(pattern);
	if (pos != string::npos)
		s.erase(pos + 1, string::npos);
}

void Strings::trim_left(string& s, const string& pattern) {
	string::size_type pos = s.find_first_not_of(pattern);
	if (pos != string::npos) {
		s.erase(0, pos);
	} else {
		if (s.size()>0) {
			s.clear();
		}
	}
}

void Strings::trim(string& s, const string& pattern) {
	Strings::trim_right(s);
	Strings::trim_left(s);
}

void Strings::erase(string& s, const string& pattern) {
	string::size_type last_pos = 0;
	string::size_type pos = s.find_first_of(pattern);
	while (pos!=string::npos) {
		last_pos=s.find_first_not_of(pattern, pos);
		s.erase(pos,last_pos-pos);
		last_pos=pos;
		pos = s.find_first_of(pattern, last_pos);
	}
}

void Strings::remove_spaces(string& s) {
	Strings::erase(s);
}
void Strings::to_lower(string& s) {
	std::transform(s.begin(), s.end(), s.begin(), (int(*)(int)) std::tolower);
}

void Strings::to_upper(string& s) {
	std::transform(s.begin(), s.end(), s.begin(), (int(*)(int)) std::toupper);
}

void Strings::to_lower(char *s) {
	while (*s) {
		*s = (char) tolower(*s);
		++s;
	}
}

void Strings::to_upper(char *s) {
	while (*s) {
		*s = (char) toupper(*s);
		++s;
	}
}


void Strings::explode(string& s, vector<string>& v, const string& delim) {
	// Skip delimiters at beginning.
	string::size_type lastPos = s.find_first_not_of(delim, 0);
	// Find first "non-delimiter".
	string::size_type pos = s.find_first_of(delim, lastPos);

	while (string::npos != pos || string::npos != lastPos) {
		// Found a token, add it to the vector.
		v.push_back(s.substr(lastPos, pos - lastPos));
		// Skip delimiters.  Note the "not_of"
		lastPos = s.find_first_not_of(delim, pos);
		// Find next "non-delimiter"
		pos = s.find_first_of(delim, lastPos);
	}
}



void Strings::implode(string& s,  vector<string>& v, const string& delim) {
	u32 i;

	for (i=0;i<v.size();++i) {
		s+=v[i];
		if (i!=(v.size()-1)) {
			if (delim.size()>0) s+=delim;
		}
	}
}

void Strings::implode(string& s, vector<char>& v, const string& delim) {
	u32 i;

	for (i=0;i<v.size();++i) {
		s+=v[i];
		if (i!=(v.size()-1)) {
			if (delim.size()>0) s+=delim;
		}
	}
}

bool Strings::starts_with(string& s, string& st_str) {
	return (strncmp(s.c_str(),st_str.c_str(), st_str.size())==0) ? true : false;
}

bool Strings::starts_with(string& s, char *st_str) {
	return (strncmp(s.c_str(),st_str, strlen(st_str))==0) ? true : false;
}

bool Strings::starts_with(string& s, const char *st_str) {
	return (strncmp(s.c_str(),const_cast<char *>(st_str),strlen(st_str))==0) ? true : false;
}

bool Strings::ends_with(string& s, string& st_str) {
	if (s.size()<st_str.size()) return false;
	u32 length=st_str.size();
	return (strcmp(&s.c_str()[s.size()-length],st_str.c_str())==0) ? true : false;
}

bool Strings::ends_with(string& s, char *st_str) {
	u32 length=static_cast<u32>(strlen(st_str));
	if (s.size()<length) return false;
	return (strcmp(&s.c_str()[s.size()-length],st_str)==0) ? true : false;
}

bool Strings::ends_with(string& s, const char *st_str) {
	u32 length=static_cast<u32>(strlen(st_str));
	if (s.size()<length) return false;
	return (strcmp(&s.c_str()[s.size()-length],const_cast<char *>(st_str))==0) ? true : false;
}

bool Strings::is_integer(string& s) {
	try {
		boost::lexical_cast<i32>(s.c_str());
	} catch (...) {
		return false;
	}
	return true;
}

bool Strings::is_natural(string& s) {
	try {
		boost::lexical_cast<u32>(s.c_str());
	} catch (...) {
		return false;
	}
	return true;
}

bool Strings::is_float(string& s) {
	try {
		boost::lexical_cast<double>(s.c_str());
	} catch (...) {
		return false;
	}
	return true;
}

bool Strings::is_numeric(string& s) {
	return Strings::is_integer(s) || Strings::is_float(s);
}

void Strings::replace(string& s, char src, char repl) {
	string::size_type i;
	for (i=0;i!=s.length();++i) {
		if (s[i]==src) {
			s[i]=repl;
		}
	}
}

template<typename T>
bool converter(string& s, T& dst ) {
	std::istringstream iss(s);
	return iss >> dst != 0;
}

int  Strings::to_int(string& s) {
	int value;
	converter<int>(s, value);
	return value;
}

float Strings::to_float(string& s) {
	float value;
	converter<float>(s, value);
	return value;
}

double Strings::to_double(string& s) {
	double value;
	converter<double>(s, value);
	return value;
}

size_t Strings::position_of(string& s, string& st_str) {
	return static_cast<size_t>(s.find(st_str));
}

size_t Strings::position_of(string& s, char *st_str) {
	return static_cast<size_t>(s.find(st_str));
}

void Strings::cut(string& s, size_t pos) {
	s.resize(pos);
}


