/*
 * exception.h
 *
 *  Created on: Apr 2, 2015
 *      Author: richer
 */

#ifndef EXCEPTION_H_
#define EXCEPTION_H_

#include <stdexcept>
#include <string>
#include <iostream>
#include <sstream>
#include <cassert>
#include <sstream>
using namespace std;
#include "types.h"
#include "terminal.h"



namespace base {

enum {
	EXC_GENERAL = 0,
	EXC_ARGUMENT_REQUIRED,
	EXC_ARGUMENT_NOT_NEEDED,
	EXC_BAD_VALUE,
	EXC_BAD_TYPE,
	EXC_OUT_OF_RANGE,
	EXC_DOES_NOT_EXIST,
	EXC_ALREADY_EXIST,
	EXC_OUT_OF_MEMORY,
	EXC_FILE_ERROR,
	EXC_NOT_IMPLEMENTED
};

/**
 * macro used to raise exception
 */

#define throw_t(type) throw Exception(type, __FILE__, __LINE__) 
#define throw_c(type, message) Exception::cexc << message; throw Exception(type, __FILE__, __LINE__)

/**
 * Model class for Exception to capture information and print it
 */

class Exception : public std::exception {
protected:
	u32 m_type;
	const char *m_file;
	i32 m_line;

public:
	static ostringstream cexc;

	/**
	 * create exception
	 * @param type type of exception
	 * @param file fine in which the exception is created
	 * @param line line in file where the exception is created
	 */
	Exception(u32 type, const char *file, i32 line);

	/**
	 * destructor
	 */
	~Exception() throw();

	/**
	 * return error message to print
	 */
	const char *what() const throw();


};

}

#endif /* EXCEPTION_H_ */
