#ifndef TEST_COMMAND_LINE_H
#define TEST_COMMAND_LINE_H

#include "cppunit/TestCase.h"
#include "cppunit/TestFixture.h"
#include "cppunit/TestCaller.h"
#include "cppunit/TestResult.h"
#include "cppunit/TestSuite.h"
#include "cppunit/CompilerOutputter.h"
#include "cppunit/XmlOutputter.h"
#include "cppunit/ui/text/TestRunner.h"

#include "base/command_line.h"
using namespace base;

// Use those macros and repeat the class name three times in
// CLASS_NAME, CLASS_NAME_STRING, OUTPUT_XML_FILE
#define CLASS_NAME CommandLine
#define CLASS_NAME_STRING "CommandLine"
#define OUTPUT_XML_FILE "test_command_line.xml"


#define TEST_DECL(x) void test_##x()
#define ADD_TEST(name) \
	suite->addTest(new CppUnit::TestCaller<TestFixture>("test_"#name, \
		&TestFixture::test_##name));


class TestFixture : public CppUnit::TestFixture {
private:
	
public:
	void setUp();
	void tearDown();


	TEST_DECL(arguments);

};

#endif 
