/*
 * exception.cpp
 *
 *  Created on: Apr 2, 2015
 *      Author: richer
 */

#include "exception.h"

using namespace base;

ostringstream Exception::cexc;

static std::string exception_message[] = {
		"general error",
		"argument required but not provided",
		"argument provided but not required",
		"value not allowed",
		"type of value is wrong",
		"out of range",
		"value does not exist",
		"value already exist",
		"out of memory",
		"file error",
		"not implemented"
};

Exception::Exception(u32 type, const char *file, i32 line) : std::exception() {
	m_type = type;
	m_file = file;
	m_line = line;
}


Exception::~Exception() throw() {
}

static string error_message;

const char *Exception::what() const throw() {
	std::ostringstream oss;
	oss << "exception type: (" << m_type << ") " << exception_message[m_type] << endl;
	oss << "raised in file \"" << m_file << "\" at line " << m_line << endl;

	if (cexc.str().size() != 0) {
		oss << "probable cause: " << cexc.str() << endl;
	}

	error_message = oss.str();
	return error_message.c_str();
}


