<?php 
require_once('model/customer.php');
require_once('model/command.php');
require_once('model/commprod.php');
require_once('model/product.php');
require_once('persistence/customer_dao.php');
require_once('persistence/command_dao.php');
require_once('persistence/commprod_dao.php');
require_once('persistence/product_dao.php');

class TestGlobal {

	protected $cudao;
	protected $codao;
	protected $cpdao;
	protected $prdao;
	
	public function __construct() {
		$this->cudao=new DAO('Customer','customer');
		$this->codao=new DAO('Command','command');
		$this->cpdao=new DAO('Commprod','commprod');
		$this->prdao=new DAO('Product','product');
	}

	
	protected function tearDown() {
		unset($this->cudao);
		unset($this->codao);
		unset($this->cpdao);
		unset($this->prdao);
	}
	
	
	public function test_truncate() {
		$this->cudao->truncate();
		$this->codao->truncate();
		$this->cpdao->truncate();
		$this->prdao->truncate();
	}
		
	
	public function test_insert_customers() {
		$cu=new Customer();
		$cu->setFirstName("Jean-Michel");
		$cu->setLastName("Richer");
		$cu->setEmail("jmr@.jmr.fr");
		$cu->setPassword("toto");
		$cu->setRights(1);
		$this->cudao->create($cu);
		assert($cu->getId()==1);
	}
	

	public function test_insert_products() {
		$pr=new Product();
		$pr->setLabel("product 1");
		$pr->setStockQty(10);
		$pr->setUnitPrice(10);
		$this->prdao->create($pr);
		assert($pr->getId()==1);
		
		$pr->setLabel("product 2");
		$pr->setStockQty(20);
		$pr->setUnitPrice(20);
		$this->prdao->create($pr);
		assert($pr->getId()==2);
		
		$pr->setLabel("product 3");
		$pr->setStockQty(30);
		$pr->setUnitPrice(30);
		$this->prdao->create($pr);
		assert($pr->getId()==3);
		
	}
	
	
	public function test_insert_commprods() {
		$cp=new Commprod();
		$cp->setCoId(1);
		$cp->setPrId(1);
		$cp->setQty(1);
		$this->cpdao->create($cp);
		assert($cp->getId()==1);
		
		$cp->setCoId(1);
		$cp->setPrId(2);
		$cp->setQty(2);
		$this->cpdao->create($cp);
		assert($cp->getId()==2);
		
		$cp->setCoId(1);
		$cp->setPrId(3);
		$cp->setQty(3);
		$this->cpdao->create($cp);
		assert($cp->getId()==3);
		
	}
	
	
	public function test_insert_commands() {
		$co=new Command();
		$co->setCuId(1);
		$co->setDate('2010-01-01');
		$co->setNbCmdlines(3);
		$co->setTotalPrice(140);
		$this->codao->create($co);
		assert($co->getId()==1);
	}	
		
	
	public function test_retrieve_by_id() {
		unset($this->codao);
		$this->codao=new CommandDAO();
		$co=$this->codao->retrieveById(1);
		//echo $co->__toString();
		assert($co->getId()==1);
		assert($co->getCuId()==1);
		assert($co->getTotalPrice()==140);
		assert($co->getNbCmdlines()==3);
		$cu=$co->getCustomer();
		assert($cu->getFirstName()=="Jean-Michel");
		$list=$co->getCommprods();
		assert(count($list)==3);
		$index=1;
		$total=0.0;
		foreach($list as $item) {
			assert($item->getQty()==$index);
			$pr=$item->getProduct();
			$total+=$item->getQty() * $pr->getUnitPrice();
			++$index;	
		}
		assert($co->getTotalPrice()==$total);
	}
	
	
	public function test_update() {
		unset($this->codao);
		$this->codao=new CommandDAO();
		$co=$this->codao->retrieveById(1);
		$list=$co->getCommprods();
		unset($list[1]);
		$co->setCommprods($list);
		$co->setNbCmdlines(2);
		$co->setTotalPrice(100.0);
		$this->codao->update($co);
	}
	
	public function test_retrieve_by_id_again() {
		unset($this->codao);
		$this->codao=new CommandDAO();
		$co=$this->codao->retrieveById(1);
		echo $co->__toString();
	}

}

$test=new TestGlobal();
$test->test_truncate();
$test->test_insert_customers();
$test->test_insert_products();
$test->test_insert_commprods();
$test->test_insert_commands();
$test->test_retrieve_by_id();
$test->test_update();
$test->test_retrieve_by_id_again();

?>
