<?php
require_once('mapping_descriptor.php');

class ReverseEngineering {
	protected $mapping_file_name;
	protected $model_directory_name;
	protected $persistence_directory_name;


	public function __construct($mfn,$mdn,$pdn) {
		$this->mapping_file_name=$mfn;
		$this->model_directory_name=$mdn;
		$this->persistence_directory_name=$pdn;
	}

	private function generate_orm($mappings) {
		$s="<?php\nrequire_once('mapping.php');\n\n";
		$s.="class ORM {\n";
		foreach($mappings as $mapping) {
			$s.="\tprivate static \$".$mapping->getClassName()."ORM = array(\n";
			$arrays=array();
			foreach($mapping->getAttributes() as $attribute) {
				$t="\t\tarray(\"".$attribute->getAttributeName()."\",";
				$t.="\"".$attribute->getColumnName()."\",";
				$t.="\"".$attribute->getType()."\",";
				$t.=$attribute->getSize();
				if ($attribute->getIdentifier()==true) {
					$t.=", true";
				}
				$t.=")";
				$arrays[]=$t;
			}
			$s.=join(",\n",$arrays);
			$s.="\n\t);\n";
		}
		
		$t=<<<HEREDOC
		
	static function getMappingForClass(\$arr) {
		\$mapping=new Mapping();
		foreach(\$arr as \$row) {
			\$assoc=new MappingAssociation(
				\$row[0], \$row[1], \$row[2], \$row[3]
			);
			if (count(\$row)>4) {
				\$assoc->setIdentifier(true);
			}
			\$mapping->add(\$assoc);
		}
		return \$mapping;
	}
HEREDOC;
		$s.=$t;
		
		$s.="\n\n\tstatic function getMapping(\$className) {\n";
		$output=array();
		
		foreach($mappings as $mapping) {
			$className=$mapping->getClassName();
			$t="if (strpos(\$className,\"$className\")!==false) {\n";
			$t.="\t\t\treturn ORM::getMappingForClass(ORM::\$".$className."ORM);\n";
			$t.="\t\t}";
			$output[]=$t;
		}
		$s.="\t\t".join($output," else ");
		$s.=" else {\n\t\t\tthrow new exception(\"unknown class name\");\n\t\t}";
		$s.="\n\t}\n";
		$s.="\n}\n?>\n";
		
		file_put_contents($this->persistence_directory_name."/orm.php", $s);	
	}
	
	
	public function process() {
		echo str_pad("",40,"=")."\n";
		echo "Perform Reverse Engineering on file ".$this->mapping_file."\n";
		echo str_pad("",40,"=")."\n";
		
		$doc = new DOMDocument('1.0','utf-8');
		$doc->load($this->mapping_file_name);
		
		if (!$doc->validate()) die("error while parsing ".$this->mapping_file_name);

		// find all mappings in XML file
		$xpath = new DOMXpath($doc);
		$xpath_mappings = $xpath->query("//mapping");
		
		
		

		// associative array of mappings in memory
		$mappings=array();

		echo "==> found the following mappings:\n";
		foreach($xpath_mappings as $xpath_mapping) {
			echo $xpath_mapping->getAttribute("class")." <--> ".
				$xpath_mapping->getAttribute("table")."\n";
		}
		
		// populate mappings
		foreach($xpath_mappings as $xpath_mapping) {
			$mapping=new MappingDescriptor();
			$mappings[$xpath_mapping->getAttribute("class")]=$mapping;
			$mapping->setTableName($xpath_mapping->getAttribute("table"));
			$mapping->setClassName($xpath_mapping->getAttribute("class"));
			$mapping->setTablePrefix($xpath_mapping->getAttribute("prefix"));

			echo "==> read relations for mapping ".$mapping->getTableName()."\n";
			foreach($xpath_mapping->childNodes as $node) {
				if ($node->nodeName=="relation") {
					$relation=new MappingRelation();
					$relation->setType($node->getAttribute("type"));
					$relation->setAttributeName($node->getAttribute("attribute"));
					$relation->setClassName($node->getAttribute("class"));
					$relation->setCrud($node->getAttribute("crud"));
						
					echo "\t".$node->getAttribute("type")." ".$node->getAttribute("class")."\n";
					$mapping->addRelation($relation);
				}
			}
		}
		
		// generate code for classes
		foreach($mappings as $mapping) {
			echo "==> generate code for class ".$mapping->getClassName()."\n";
			$mapping->generateClassCode();
			echo "==> generate code for DAO   ".$mapping->getClassName()."\n";
			$mapping->generateDaoCode($mappings);
			file_put_contents($this->model_directory_name."/".
				strtolower($mapping->getClassName()).".php", $mapping->getClassCode());
			file_put_contents($this->persistence_directory_name."/".
				strtolower($mapping->getClassName())."_dao.php", $mapping->getDaoCode());
			
		}
		
		$this->generate_orm($mappings);
	}
}

$re=new ReverseEngineering("mappings.xml","../model","../persistence");

$re->process();
?>
