<?php
require_once('mapping_relation.php');
require_once('attribute.php');
require_once('relational_attribute.php');
require_once('../persistence/database_connection.php');


class MappingDescriptor {
	protected $tableName;
	protected $tablePrefix;
	protected $className;
	protected $relations;
	protected $classCode;
	protected $daoCode;
	protected $attributes;

	
	public function __construct() {
		$this->tableName="";
		$this->tablePrefix="";
		$this->className="";
		$this->relations=array();
		$this->classCode="";
		$this->daoCode="";
		$this->attributes=array();
	}
	
	public function getTableName() {
		return $this->tableName;
	}
	
	public function getTablePrefix() {
		return $this->tablePrefix;	
	}
	
	public function getClassName() {
		return $this->className;
	}
	
	public function getClassCode() {
		return $this->classCode;
	}
	
	public function getDaoCode() {
		return $this->daoCode;
	}
	
	public function getAttributes() {
		return $this->attributes;
	}
	
	public function setTableName($value) {
		$this->tableName=$value;
	}
	
	public function setTablePrefix($value) {
		$this->tablePrefix=$value;
	}

	public function setClassName($value) {
		$this->className=$value;
	}
	
	
	public function addRelation($relation) {
		$this->relations[]=$relation;
	}
	
	private function generateRequire() {
		$result="";
		foreach($this->relations as $relation) {
			$result.="require_once('".strtolower($relation->getClassName()).".php');\n";
		}	
		return $result;
	}
	
	public function generateClassCode() {
		$s="<?php\n";
		
		$s.=$this->generateRequire();
		$s.="\nclass ".$this->className." {\n";
		// generate attributes
		$connection=DatabaseConnection::getInstance()->getConnection();
		
		$query="desc ".$this->tableName.";";
		$result=$connection->query($query);
		if ($result===false) {
			throw new exception("unable to get description of table ".$this->tableName);
		}
		$result->setFetchMode(PDO::FETCH_ASSOC);
		$records=$result->fetchAll();
		$columnIndex=1;
		$modelName=ucfirst($this->tableName);
		
		foreach($records as $record) {
			$attribute=new Attribute();
			$this->attributes[]=$attribute;
			
			$columnName=$record["Field"];
			$attribute->setColumnName($columnName);
			$columnName=substr($columnName,3);
			
			$attributeName=strtok($columnName, "_");
			$token=strtok("_");
			while ($token !== false) {
    			$attributeName.=ucFirst($token);	
    			$token=strtok("_");
			}
			$attribute->setAttributeName($attributeName);
			
			$columnType=$record["Type"];
			
			$columnKey=$record["Key"];
			
			preg_match("/[a-z]+/",$columnType,$types);
			preg_match("/\(([0-9]+)\)/",$columnType,$sizes);
			
			$attribute->setType($types[0]);
			if (count($sizes)==2) {
				$attribute->setSize($sizes[1]);
			} else {
				$attribute->setSize(1);
			}
			
			if ($columnKey=="PRI") {
				$attribute->setIdentifier(true);
			}
			
			$s.="\tprotected $".$attributeName.";\n";
		}
		$s.="\t// relational fields \n";
		foreach($this->relations as $relation) {
			$s.="\tprotected \$".$relation->getAttributeName().";\n";
		}
		
		// ------------------------------
		// generate constructor
		$s.="\n\n\t/**\n\t * default constructor\n\t */\n";
		$s.="\tpublic function __construct() {\n";
		foreach($this->attributes as $attribute) {
			$s.="\t\t\$this->".$attribute->getAttributeName()."=0;\n";
		}
		foreach($this->relations as $relation) {
			$s.="\t\t\$this->".$relation->getAttributeName()."=";
			if ($relation->getType()=="one") {
				$s.="new ".$relation->getClassName()."()";
			} else {
				$s.="array()";
			}
			$s.=";\n";
		} 
		$s.="\n\t}\n\n";
		
		// --------------------------------
		// generate toString
		$s.="\n\tpublic function __toString() {\n";
		$s.="\t\t\$s=var_export(\$this,true);\n";
		$s.="\t\treturn \$s;\n";
		$s.="\t}\n\n";
		
		// ------------------------
		// generate getters
		$s.="\t//".str_pad("",40,"-")."\n";
		$s.="\t// getters\n";
		$s.="\t//".str_pad("",40,"-")."\n";
		foreach($this->attributes as $attribute) {
			$s.="\n\tpublic function get".ucFirst($attribute->getAttributeName())."() {\n";
			$s.="\t\treturn \$this->".$attribute->getAttributeName().";";
			$s.="\n\t}\n";
		}
		// generate relational getters
		foreach($this->relations as $relation) {
			$s.="\n\tpublic function get".ucFirst($relation->getAttributeName())."() {\n";
			$s.="\t\treturn \$this->".$relation->getAttributeName().";";
			$s.="\n\t}\n";
		}
		
		// generate setters
		$s.="\n";
		$s.="\t//".str_pad("",40,"-")."\n";
		$s.="\t// setters\n";
		$s.="\t//".str_pad("",40,"-")."\n";
		foreach($this->attributes as $attribute) {
			$s.="\n\tpublic function set".ucFirst($attribute->getAttributeName())."(\$value) {\n";
			$s.="\t\t\$this->".$attribute->getAttributeName()." = \$value;";
			$s.="\n\t}\n";
		}
		// generate relational getters
		foreach($this->relations as $relation) {
			$s.="\n\tpublic function set".ucFirst($relation->getAttributeName())."(\$value) {\n";
			$s.="\t\t\$this->".$relation->getAttributeName()." = \$value;";
			$s.="\n\t}\n";
		}
		
		$s.="}\n?>\n";
		$this->classCode=$s;
	}
	
	/**
	 * 
	 * @return unknown_type
	 */
	public function generateDaoCode($mappings) {
		$s="<?php\n";
		$s.="require_once('dao.php');\n";
		foreach($this->relations as $relation) {
			 if (in_array("retrieve*",$relation->getCrud())) {
			 	$s.="require_once('".strtolower($relation->getClassName())."_dao.php');\n";
			 }
		}
		$s.="\nclass ".$this->className."DAO extends DAO {\n\n";
		$s.="\tfunction __construct() {\n";
		$s.="\t\tparent::__construct('".$this->className."','".$this->tableName."');\n";
		$s.="\t}\n\n";
	
		// generate create
		$s.="\tpublic function createRelations(\$object) {\n";
		foreach($this->relations as $relation) {
			$crud=$relation->getCrud();
			if (in_array("create",$crud)) {
				$s.="\t\t\$dao=new DAO('".$relation->getClassName()."','".
					$mappings[$relation->getClassName()]->getTableName()."');\n";
				$s.="\t\tforeach(\$object->get".ucfirst($relation->getAttributeName())."() as \$item) {\n";
				$s.="\t\t\t\$dao->create(\$item);\n";
				$s.="\t\t}\n";
			}
		}
		$s.="\t}\n\n";
		
		// generate delete
		$s.="\tpublic function deleteRelations(\$object) {\n";
		foreach($this->relations as $relation) {
			$crud=$relation->getCrud();
			if (in_array("delete",$crud)) {
				$s.="\t\t\$dao=new DAO('".$relation->getClassName()."','".
					$mappings[$relation->getClassName()]->getTableName()."');\n";
				$field=$mappings[$relation->getClassName()]->getTablePrefix().
					"_".$this->tablePrefix."_id";
				$s.="\t\t\$dao->deleteAll(\"".$field."=\".\$object->getId());\n";
			}
		}	
		$s.="\t}\n\n";
		
		// generate update
		$s.="\tpublic function updateRelations(\$object) {\n";
		$s.="\t\t\$this->deleteRelations(\$object);\n";
		$s.="\t\t\$this->createRelations(\$object);\n";
		$s.="\t}\n\n";
		
		// generate retrieve
		$s.="\tpublic function retrieveRelations(\$object) {\n";
		foreach($this->relations as $relation) {
			$crud=$relation->getCrud();
			if (in_array("retrieve",$crud)) {
				$s.="\t\t\$dao=new DAO('".$relation->getClassName()."','".
				$mappings[$relation->getClassName()]->getTableName()."');\n";
			} else if (in_array("retrieve*",$crud)) {
				$s.="\t\t\$dao=new ".$relation->getClassName()."DAO();\n";
			}
			
			if ($relation->getType()=="one") {
				$s.="\t\t\$object->set".ucfirst($relation->getAttributeName()).
					"(\$dao->retrieveById(\$object->get".substr($relation->GetClassName(),0,2)."Id()));\n";
			} else {
				$field=$mappings[$relation->getClassName()]->getTablePrefix().
					"_".$this->tablePrefix."_id";
				$s.="\t\t\$object->set".ucfirst($relation->getAttributeName()).
					"(\$dao->retrieveAll(\"".$field."=\".\$object->getId()));\n";
			}
		}
		$s.="\t}\n";
		
		$s.="\n}\n?>\n";
		$this->daoCode=$s;
	}
}

?>
