<?php
require_once('mapping.php');

class ORM {
	private static $CommandORM = array(
		array("id","co_id","int",11, true),
		array("date","co_date","date",1),
		array("cuId","co_cu_id","int",11),
		array("totalPrice","co_total_price","float",1),
		array("nbCmdlines","co_nb_cmdlines","int",11)
	);
	private static $CustomerORM = array(
		array("id","cu_id","int",11, true),
		array("firstName","cu_first_name","varchar",30),
		array("lastName","cu_last_name","varchar",30),
		array("email","cu_email","varchar",60),
		array("password","cu_password","varchar",32),
		array("rights","cu_rights","int",11)
	);
	private static $CommprodORM = array(
		array("id","cp_id","int",11, true),
		array("coId","cp_co_id","int",11),
		array("prId","cp_pr_id","int",11),
		array("qty","cp_qty","int",11)
	);
	private static $ProductORM = array(
		array("id","pr_id","int",11, true),
		array("label","pr_label","varchar",80),
		array("stockQty","pr_stock_qty","int",11),
		array("unitPrice","pr_unit_price","float",1)
	);
		
	static function getMappingForClass($arr) {
		$mapping=new Mapping();
		foreach($arr as $row) {
			$assoc=new MappingAssociation(
				$row[0], $row[1], $row[2], $row[3]
			);
			if (count($row)>4) {
				$assoc->setIdentifier(true);
			}
			$mapping->add($assoc);
		}
		return $mapping;
	}

	static function getMapping($className) {
		if (strpos($className,"Command")!==false) {
			return ORM::getMappingForClass(ORM::$CommandORM);
		} else if (strpos($className,"Customer")!==false) {
			return ORM::getMappingForClass(ORM::$CustomerORM);
		} else if (strpos($className,"Commprod")!==false) {
			return ORM::getMappingForClass(ORM::$CommprodORM);
		} else if (strpos($className,"Product")!==false) {
			return ORM::getMappingForClass(ORM::$ProductORM);
		} else {
			throw new exception("unknown class name");
		}
	}

}
?>
