<?php
/**
 * This class is used to describe the mapping between :
 * <ul>
 * <li>an attribute of a class</li>
 * <li>and a column in a table of a relational database</li>
 * </ul>
 * @author Jean-Michel Richer
 * 
 */
class MappingAssociation {
	/**
	 * name of attribute in the class
	 */
	protected $attributeName;
	
	/**
	 * name of the column in table of relational database
	 */
	protected $columnName;
	
	/**
	 * type of column (string, varchar, int, float, date, timestamp, boolean, ...)
	 */
	protected $type;
	
	/**
	 * size if column is of type string or varchar
	 */
	protected $size;
	
	/**
	 * index of column in table
	 */
	protected $columnIndex;
	
	/**
	 * flag used to indicate if this mapping concerns an identifier
	 */
	protected $identifier;
	
	/**
	 * default constructor
	 * @param string $attributeName
	 * @param string $columnName
	 * @return void
	 */
	function __construct($attributeName, $columnName, $type, $size) {
		$this->attributeName=$attributeName;
		$this->columnName=$columnName;
		$this->type=$type;
		$this->identifier=false;
		$this->columnIndex=-1;
		$this->size=$size;
	}
	
	function getAttributeName() {
		return $this->attributeName;
	}
	
	function getColumnName() {
		return $this->columnName;
	}
	
	function getColumnIndex() {
		return $this->columnIndex;
	}
	
	function getType() {
		return $this->type;
	}
	
	function getSize() {
		return $this->size;
	}
	
	function isIdentifier() {
		return $this->identifier;
	}
	
	function setidentifier($identifier) {
		$this->identifier=$identifier;
	}
	
	function setAttributeName($attributeName) {
		$this->attributeName=$attributeName;
	}
	
	function setColumnName($columnName) {
		$this->columnName=$columnName;
	}
	
	function setColumnIndex($index) {
		$this->columnIndex=$index;
	}
	
	/**
	 * set type of MappingAssociation from database information
	 * @param $type
	 * @return unknown_type
	 */
	function setType($type) {
		$a=new ArrayObject();
		$token=strtok($type," ()");
		while ($token!==false) {
			$a->append($token);
			$token=strtok(" ()");
		}
		if ($a->count()>=2) {
			$this->type=$a[0];
			$this->size=$a[1];
		} else {
			$this->type=$a[0];
		}
		
	}
}
?>