<?php
require_once('mapping_association.php');

/**
 * This class describes an ORM between attributes of a class and
 * columns of a table of a relational database
 * 
 * @author Jean-Michel Richer
 *
 */
class Mapping {
	/**
	 * name of class
	 */
	protected $className;
	
	/**
	 * name of table
	 */
	protected $tableName;
	
	/**
	 * list of correspondences between attributes and columns
	 */
	protected $associations;
	
	/**
	 * default constructor
	 * @return void
	 */
	function __construct() {
		$this->className="";
		$this->tableName="";
		$this->associations=new ArrayObject();
	}
	
	function setClassName($className) {
		$this->className=$className;
	}
	
	function setTableName($tableName) {
		$this->tableName=$tableName;
	}
	
	function add($assoc) {
		$this->associations[]=$assoc;
	}
	
	/**
	 * return MappingAssociation that corresponds to column index
	 * @param $index index of column in the table 
	 * @return MappingAssociation or null if not found
	 */
	function getFromColumnIndex($index) {
		$iterator=$this->associations->getIterator();
		while ($iterator->valid()) {
			$assoc=$iterator->current();
			if ($assoc->getColumnIndex()==$index) return $assoc;
			$iterator->next();
		}
		return null;
	}
	
	/**
	 * return MappingAssociation that corresponds to name of column in the table 
	 * @param $columnName name of the column in the table 
	 * @return MappingAssociation or null if not found
	 */
	function getFromColumnName($name) {
		$iterator=$this->associations->getIterator();
		while ($iterator->valid()) {
			$assoc=$iterator->current();
			if ($assoc->getColumnName()==$name) return $assoc;
			$iterator->next();
		}
		return null;
	}
	
	/**
	 * return MappingAssociation that corresponds to name of attribute of the class
	 * @param $attributeName name of attribute of class
	 * @return MappingAssociation or null if not found
	 */
	function getFromAttributeName($name) {
		$iterator=$this->associations->getIterator();
		while ($iterator->valid()) {
			$assoc=$iterator->current();
			if ($assoc->getAttributeName()==$name) return $assoc;
			$iterator->next();
		}
		return null;
	}
	
	function getClassName() {
		return $this->className;
	}
	
	function getTableName() {
		return $this->tableName;
	}
	
	function values() {
		return $this->associations->getIterator();
	}
	
	
}