<?php
/**
 * Interface to implement CRUD
 * <ul>
 * <li>Create</li>
 * <li>Retrieve</li>
 * <li>Update</li>
 * <li>Delete</li>
 * </ul>
 * We assume that the object passed as a parameter has the following properties
 * <ul>
 * <li>relies on a JavaBean-like implementation</li> 
 * <li>has a unique identifier called <b>id</b> 
 * </ul>
 * 
 * @author Jean-Michel Richer
 *
 */
interface CRUDInterface {
	/**
	 * create a new object, after creation, the identifier field (id) is set
	 * from database information
	 * @param $object object to insert into related table
	 * @return void
	 */
	public function create($object);
	
	/**
	 * retrieve unique object from its identifier provided from attribute id
	 * of the object. Object attributes are set from database columns
	 * @param $object
	 * @return object
	 */
	public function retrieveByObjectId($object);
	
	/**
	 * retrieve unique object
	 * @param integer $id
	 * @return unknown_type
	 */
	public function retrieveById($id);
	
	/**
	 * retrieve all objects that correspond to given criterion, 
	 * object attributes are set from database columns.
	 * For example, criterion can be "price>100 AND stock<10"
	 * @param string $sqlWhere search criterion written in SQL
	 * @return array of objects
	 */
	public function retrieveAll($sqlWhere);
	
	/**
	 * return number of records that correspond to given criterion
	 * @param string $sqlWhere search criterion written in SQL
	 * @return integer, 0 if not found
	 */
	public function count($sqlWhere);
	
	/**
	 * update object, the identifier of the object is used to access the
	 * object
	 * @param class $object
	 */
	public function update($object);
	
	/**
	 * delete object with identifier of the object
	 * @param $object
	 */
	public function delete($object);
	
	/**
	 * delete object with supplied identifier
	 * @param $id numeric identifier in database
	 */
	public function deleteId($id);
	
	/**
	 * delete all objects that correspond to given criterion
	 * @param string $sqlWhere search criterion written in SQL
	 */
	public function deleteAll($sqlWhere);
	
} 
?>